<?php
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT");

defined('BASEPATH') OR exit('No direct script access allowed');

class Bilan extends CI_Controller {

	public function index($id_year=null)
	{
		if(  $this->session->logged_in ){
			if(check_privilege('bilan', $this->session->user['id_role'], 'voir')){

				$entreprise_salesiennes 	= $this->Entreprise_salesienne_model->get_all_entreprise_salesiennes();
				$entreprise_salesienne      = [];
				$id_entreprise_salesienne 	= (int) $_SESSION['user']['id_foreign_entreprise_salesienne'];
				$sous_comptable_affectee 	= null;
				$current_month_date 		= "";
				$next_month_date 			= "";
				$current_year_date 			= "";
				$next_year_date 			= "";
				$annee_excerice 			= null;
				$annee_excerice_next 		= null;
				$bilan_link_active  		= '';
				$bilan_initial_link_active  = '';
				$label_bilan				= '';
				$actifs_immobilises_array	= [];
				$actifs_circulants_array	= [];
				$tresoreries_actifs_array 	= [];
				$capitaux_propres_array		= [];
				$passifs_circulants_array	= [];
				$compte_resultat_array		= [];
				$actif_circulant_cat_trois_array	= [];
				$actif_circulant_provision_cat_trois_array	= [];
				$actif_circulant_provision_cat_quatre_array	= [];
				$actif_circulant_provision_cat_cinq_array	= [];
				$actif_circulant_cat_quatre_array	= [];
				$passif_circulant_cat_quatre_array	= [];
				$total_immo	= 0;
				$total_net 	= 0;
				$total_capitaux_permanent = 0;
				$total_fond_roulement_one = 0;
				$total_fond_roulement_two = 0;
				$total_solde_caisse		  = 0;
				$total_solde_banque		  = 0;
				$total_disponibles 		  = 0;
				$total_actif_circulant 	  = 0;
				$total_actifs		 	  = 0;
				$total_passifs		 	  = 0;
				$balance_actifs		 	  = 0;
				$id_year 				  = ($id_year == null AND !isset($id_year) ) ? date('Y') : $id_year;
				$bilan_start_date 		  = '';
				$bilan_end_date 		  = '';
				

				if( isset( $_POST['annee_exercice'] )  OR ( isset($id_year) AND $id_year <> null ) ){

					$annee_excerice 	 	 =  ( isset($_POST['annee_exercice']) ) ? $_POST['annee_exercice'] : $id_year;
					$_POST['annee_exercice'] =  ( isset($_POST['annee_exercice']) ) ? $_POST['annee_exercice'] : $id_year;
					$annee_excerice_next 	 =  (int) $annee_excerice + 1;
					$bilan_start_date 		 = $annee_excerice.'/09/01';
					$bilan_end_date 		 = $annee_excerice_next.'/08/31';

					$sql 				=" date_enregistrement_livre_caisse_banque BETWEEN '".$bilan_start_date."' AND '".$bilan_end_date."'";
					$sql_amortissement 	=" date_enregistrement_livre_caisse_banque <= '$bilan_end_date' ";
					$sql_caisse_banque 	=" id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
					
					if( $annee_excerice >= date('Y') )  {
						$bilan_link_active  = 'link_menu_active' ; 
						$label_bilan 		= 'FINAL';
					}
					else{
						$bilan_initial_link_active  = 'link_menu_active';
						$label_bilan 				= 'INITIAL';
					}
					
					
					if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] <> 'null'){

						if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne']  <> 0){
							$sql 				.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
							$sql_amortissement 	.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
							$sql_caisse_banque 	=" id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
						}else{
							if( $_POST['id_entreprise_salesienne'] <> 'situation de la province'){
								$sql 				.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$_POST['id_entreprise_salesienne']."";
								$sql_amortissement	.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$_POST['id_entreprise_salesienne']."";
								$sql_caisse_banque  =" id_foreign_entreprise_salesienne_livre_caisse_banque =".$_POST['id_entreprise_salesienne']."";
							}
						}
						$id_entreprise_salesienne = $_POST['id_entreprise_salesienne'];
					}else{
						$sql 				.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
						$sql_amortissement 	.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
						$sql_caisse_banque 	.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
					}


					if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] == 'situation de la province'){
						$entreprise_salesienne['nom_entreprise_salesienne'] = 'situation de la province';
						$entreprise_salesienne['id_entreprise_salesienne']  = 'situation de la province';
					}else{
						$entreprise_salesienne = $this->Entreprise_salesienne_model->get_entreprise_salesienne($id_entreprise_salesienne);
					}
					

					$sous_comptable_affectee 		= $this->_build_sous_cat_plan_comptable_array($id_entreprise_salesienne);
					$actifs_immobilises_array 		= $this->_build_actifs_immobilises_array($sous_comptable_affectee,$sql_amortissement);
					$actifs_circulants_array 		= $this->_build_actifs_circulants_array($sous_comptable_affectee,$sql_amortissement);
					$tresoreries_actifs_array 		= $this->_build_tresoreries_actifs($sous_comptable_affectee,$sql_amortissement);
					$capitaux_propres_array 		= $this->_build_capitaux_propres_array($sous_comptable_affectee,$sql_amortissement);
					$passifs_circulants_array	 	= $this->_build_passifs_circulants_array($sous_comptable_affectee,$sql_amortissement);
					$compte_resultat_array		 	= $this->_build_compte_resultat_array($sous_comptable_affectee,$sql);

					if( (int) $compte_resultat_array['solde'] == 0){
						$year	= $annee_excerice - 1;
						$sql 	= str_replace($annee_excerice.'/09/01',$year.'/09/01',$sql);
						$sql 	= str_replace(($annee_excerice+1).'/08/31',$annee_excerice.'/08/31',$sql);
						$compte_resultat_array		 	= $this->_build_compte_resultat_array($sous_comptable_affectee,$sql);
					}

					$actif_circulant_cat_trois_array	 		= $this->_build_actif_circulant_cat_trois_array($sous_comptable_affectee,$sql);
					$actif_circulant_provision_cat_trois_array	= $this->_build_actif_circulant_provision_cat_trois_array($sous_comptable_affectee,$sql);
					$actif_circulant_provision_cat_quatre_array	= $this->_build_actif_circulant_provision_cat_quatre_array($sous_comptable_affectee,$sql);
					$actif_circulant_provision_cat_cinq_array	= $this->_build_actif_circulant_provision_cat_cinq_array($sous_comptable_affectee,$sql);
					$actif_circulant_cat_quatre_array	 		= $this->_build_actif_circulant_cat_quatre_array($sous_comptable_affectee,$sql);
					$passif_circulant_cat_quatre_array	 		= $this->_build_passif_circulant_cat_quatre_array($sous_comptable_affectee,$sql);
					$total_immo  	= $actifs_circulants_array['solde'] + $actifs_immobilises_array['solde'];
					$total_net 		= $total_immo - $tresoreries_actifs_array['solde'];  
					$total_capitaux_permanent = $capitaux_propres_array['solde'] + $passifs_circulants_array['solde'] + $compte_resultat_array['solde'];
					$total_fond_roulement_one = $total_capitaux_permanent - $total_net;
					$total_fond_roulement_two = $total_net + $tresoreries_actifs_array['solde'];
					$total_solde_caisse 		= $this->_build_disponible_caisse_array($sous_comptable_affectee,$sql);
					$total_solde_banque 		= $this->_build_disponible_banque_array($sous_comptable_affectee,$sql);
					$total_disponibles 			= $total_solde_caisse['solde'] + $total_solde_banque['solde'];
					$total_actif_circulant 		= $actif_circulant_cat_trois_array['solde'] + $actif_circulant_cat_quatre_array['solde'] + $total_solde_caisse['solde'] + $total_solde_banque['solde'];
					$total_actifs_valeurs_brutes = $actifs_immobilises_array['total_sorties'] + $actifs_circulants_array['total_sorties'] + $tresoreries_actifs_array ['solde'];
					$total_actifs_am_pro 		 = $actifs_immobilises_array['total_entrees'] + $actifs_circulants_array['total_entrees'];
					$total_actifs_valeurs_nettes = $actifs_immobilises_array['solde'] + $actifs_circulants_array['solde']+ $tresoreries_actifs_array ['solde'];
					$total_passifs 				 = $capitaux_propres_array['solde'] + $passifs_circulants_array['solde'] + $compte_resultat_array['solde'];
					$balance_actifs 			 = $total_actifs - ( $tresoreries_actifs_array['solde'] + $actif_circulant_provision_cat_trois_array['solde'] + $actif_circulant_provision_cat_quatre_array['solde']+ $actif_circulant_provision_cat_cinq_array['solde'] );
				}

				

				$crud = new grocery_CRUD();
				$crud->set_table('livre_caisse_banque');
				$output = $crud->render();

				$header 	= $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$sidebar 	= $this->load->view("layouts/sidebar", [], true);
				$navbar 	= $this->load->view("layouts/menu_nav_bar", ['bilan_link_active'=>$bilan_link_active,'bilan_initial_link_active'=>$bilan_initial_link_active], true);
				$footer 	= $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$b_header 	= $this->load->view("balance/balance_header", [], true);
				$b_footer 	= $this->load->view("balance/balance_footer", [], true);

				$this->load->view("bilan/bilan", [
					'header' 	=> 	$header, 
					'navbar'	=>	$navbar, 
					'sidebar' 	=> 	$sidebar, 
					'footer' 	=> 	$footer,
					'b_header' 	=> 	$b_header,
					'b_footer' 	=> 	$b_footer,
					'output'=>$output->output,
					'annee_excerice' 	=> 	$annee_excerice,
					'annee_excerice_next' 	=> 	$annee_excerice_next,
					'current_year_date' 	=> 	$current_year_date,
					'next_year_date' 	=> 	$next_year_date,
					'current_month_date' 	=> 	$current_month_date,
					'next_month_date' 	=> 	$next_month_date,
					'oeuvre_don_bosco' 		=> 	$entreprise_salesienne,
					'entreprise_salesiennes' 		=> 	$entreprise_salesiennes,
					'actifs_immobilises_array' 	=> 	$actifs_immobilises_array,
					'actifs_circulants_array' 	=> 	$actifs_circulants_array,
					'tresoreries_actifs_array' 	=> 	$tresoreries_actifs_array,
					'capitaux_propres_array' 	=> 	$capitaux_propres_array,
					'passifs_circulants_array' 	=> 	$passifs_circulants_array,
					'compte_resultat_array' 	=> 	$compte_resultat_array,
					'actif_circulant_cat_trois_array' 	=> 	$actif_circulant_cat_trois_array,
					'actif_circulant_cat_quatre_array' 	=> 	$actif_circulant_cat_quatre_array,
					'passif_circulant_cat_quatre_array' 	=> 	$passif_circulant_cat_quatre_array,
					'total_immo' 	=> 	$total_immo,
					'total_net' 	=> 	$total_net,
					'total_capitaux_permanent' 	=> 	$total_capitaux_permanent,
					'total_fond_roulement_one' 	=> 	$total_fond_roulement_one,
					'total_fond_roulement_two' 	=> 	$total_fond_roulement_two,
					'total_solde_caisse' 	=> 	$total_solde_caisse,
					'total_solde_banque' 	=> 	$total_solde_banque,
					'total_disponibles' 	=> 	$total_disponibles,
					'total_actif_circulant' 	=> 	$total_actif_circulant,
					'total_actifs_valeurs_brutes' 	=> 	$total_actifs_valeurs_brutes,
					'total_actifs_am_pro' 	=> 	$total_actifs_am_pro,
					'total_actifs_valeurs_nettes' 	=> 	$total_actifs_valeurs_nettes,
					'total_passifs' 	=> 	$total_passifs,
					'balance_actifs' 	=> 	$balance_actifs,
					'actif_circulant_provision_cat_trois_array' 	=> 	$actif_circulant_provision_cat_trois_array,
					'actif_circulant_provision_cat_quatre_array' 	=> 	$actif_circulant_provision_cat_quatre_array,
					'actif_circulant_provision_cat_cinq_array' 	=> 	$actif_circulant_provision_cat_cinq_array,
					'label_bilan' 	=> 	$label_bilan,
				]);

			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}

		}else {
			redirect("Starter/login");
		}
	
	}


	public function bilan_export_complet($id_year=null,$id_entreprise_salesienne_in=null)
	{
		if(  $this->session->logged_in ){
			if(check_privilege('bilan', $this->session->user['id_role'], 'voir')){

				$entreprise_salesienne      = [];
				$id_entreprise_salesienne 	= ((int) $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0) ? 'situation de la province' : (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] ;
				$sous_comptable_affectee 	= null;
				$annee_excerice 			= null;
				$annee_excerice_next 		= null;
				$capitaux_propres_array		= [];
				$compte_resultat_array		= [];
				$total_passifs		 	    = 0;
				$id_year 				    = ($id_year == null AND !isset($id_year) ) ? date('Y') : $id_year;
				$bilan_start_date 		    = '';
				$bilan_end_date 		    = '';


				if($id_entreprise_salesienne_in<>null){
					$_POST['id_entreprise_salesienne'] = urldecode($id_entreprise_salesienne_in);
				}

				if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0  AND !isset($_POST['id_entreprise_salesienne']) ){
					$_POST['id_entreprise_salesienne'] = $id_entreprise_salesienne;
				}
				
				
				if( isset( $_POST['annee_exercice'] )  OR ( isset($id_year) AND $id_year <> null ) ){
						
					$annee_excerice 	 	 =  ( isset($_POST['annee_exercice']) ) ? $_POST['annee_exercice'] : $id_year;
					$_POST['annee_exercice'] =  ( isset($_POST['annee_exercice']) ) ? $_POST['annee_exercice'] : $id_year;
					$annee_excerice_next 	 =  (int) $annee_excerice + 1;
					$bilan_start_date 		 = $annee_excerice.'09/01';
					$bilan_end_date 		 = $annee_excerice_next.'/08/31';

					$sql 					 =" date_enregistrement_livre_caisse_banque BETWEEN '".$bilan_start_date."' AND '".$bilan_end_date."'";
					$sql_amortissement 		 =" date_enregistrement_livre_caisse_banque <= '$bilan_end_date' ";
					$sql_caisse_banque 		 =" id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
					
					
					
					if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] <> 'null'){

						if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne']  <> 0){
							$sql 				.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
							$sql_amortissement 	.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
							$sql_caisse_banque 	 =" id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
						}else{
							if( $_POST['id_entreprise_salesienne'] <> 'situation de la province'){
								$sql 				.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$_POST['id_entreprise_salesienne']."";
								$sql_amortissement	.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$_POST['id_entreprise_salesienne']."";
								$sql_caisse_banque   =" id_foreign_entreprise_salesienne_livre_caisse_banque =".$_POST['id_entreprise_salesienne']."";
							}
						}
						$id_entreprise_salesienne = $_POST['id_entreprise_salesienne'];
					}else{
						if( $_SESSION['user']['id_foreign_entreprise_salesienne'] <> 0 ){
							$sql 				.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
							$sql_amortissement 	.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
							$sql_caisse_banque 	.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
						}
					}


					if(  isset( $_POST['id_entreprise_salesienne'] ) AND ($_POST['id_entreprise_salesienne'] == 'situation de la province') ){
						$entreprise_salesienne['nom_entreprise_salesienne'] = 'situation de la province';
						$entreprise_salesienne['id_entreprise_salesienne']  = 'situation de la province';
					}else{
						$entreprise_salesienne = $this->Entreprise_salesienne_model->get_entreprise_salesienne($id_entreprise_salesienne);
					}

					

					$sous_comptable_affectee 		= $this->_build_sous_cat_plan_comptable_array($id_entreprise_salesienne);
					$actifs_immobilises_array 		= $this->_build_actifs_immobilises_array($sous_comptable_affectee,$sql_amortissement);
					$actifs_circulants_array 		= $this->_build_actifs_circulants_array($sous_comptable_affectee,$sql_amortissement);
					$tresoreries_actifs_array 		= $this->_build_tresoreries_actifs($sous_comptable_affectee,$sql_amortissement);
					$capitaux_propres_array 		= $this->_build_capitaux_propres_array($sous_comptable_affectee,$sql_amortissement);
					$passifs_circulants_array	 	= $this->_build_passifs_circulants_array($sous_comptable_affectee,$sql_amortissement);
					$compte_resultat_array		 	= $this->_build_compte_resultat_array($sous_comptable_affectee,$sql);

					if( (int) $compte_resultat_array['solde'] == 0){
						$year	= $annee_excerice - 1;
						$sql 	= str_replace($annee_excerice.'/09/01',$year.'/09/01',$sql);
						$sql 	= str_replace(($annee_excerice+1).'/08/31',$annee_excerice.'/08/31',$sql);
						$compte_resultat_array		 	= $this->_build_compte_resultat_array($sous_comptable_affectee,$sql);
					}

					$total_solde_caisse 		 = $this->_build_disponible_caisse_array($sous_comptable_affectee,$sql);
					$total_solde_banque 		 = $this->_build_disponible_banque_array($sous_comptable_affectee,$sql);
					$total_actifs_valeurs_brutes = $actifs_immobilises_array['total_sorties'] + $actifs_circulants_array['total_sorties'] + $tresoreries_actifs_array ['solde'];
					$total_actifs_am_pro 		 = $actifs_immobilises_array['total_entrees'] + $actifs_circulants_array['total_entrees'];
					$total_actifs_valeurs_nettes = $actifs_immobilises_array['solde'] + $actifs_circulants_array['solde']+ $tresoreries_actifs_array ['solde'];
					$total_passifs 				 = $capitaux_propres_array['solde'] + $passifs_circulants_array['solde'] + $compte_resultat_array['solde'];
					$file_export_name 			 = 'Bilan '.$entreprise_salesienne['nom_entreprise_salesienne'].' exercice '.$annee_excerice.'.pdf';
					$index_for_group_1 			 = ( count($actifs_immobilises_array) >= count($capitaux_propres_array) ) ? count($actifs_immobilises_array)-3 : count($capitaux_propres_array)-3; 
					$index_for_group_2 			 = ( count($actifs_circulants_array) >= count($passifs_circulants_array) ) ? count($actifs_circulants_array)-3 : count($passifs_circulants_array)-3; 

					$pdf = new FPDF('L','cm','A4');

					$pdf->AddPage();
					$pdf->SetAutoPageBreak(true,2);

					$pdf->SetTextColor(0,32,96);
					$pdf->SetFont('Times','','14');

					$pdf->Cell(27.8,1.5,strtoupper( 'Bilan '.$entreprise_salesienne['nom_entreprise_salesienne'].' exercice '.$annee_excerice ),'',1,'L');
					$pdf->Image(base_url('assets/dore_assets').'/img/logo_salesien_bg.png',25,0.1,2.5,2.5);

					$pdf->SetFillColor(0,32,96);
					$pdf->SetTextColor(255,255,255);
					$pdf->SetFont('Times','','12');

					$pdf->Cell(16.9,1.5,'ACTIF','LTB',0,'C',true);
					$pdf->Cell(10.9,1.5,'PASSIF','TRB',1,'C',true);

					$pdf->SetTextColor(0,0,0);
					$pdf->SetFont('Times','','10');
					$pdf->Cell(3.38,1,'CODE COMPTABLE','LBR',0,'C');
					$pdf->Cell(3.38,1,'DESIGNATION','BR',0,'C');
					$pdf->Cell(3.38,1,'VALEURS BRUTS $','BR',0,'C');
					$pdf->Cell(3.38,1,'AM & PRO $','BR',0,'C');
					$pdf->Cell(3.38,1,'VALEURS NETTES $','BR',0,'C');
					$pdf->Cell(3.63,1,'CODE COMPTABLE','BR',0,'C');
					$pdf->Cell(3.63,1,'DESIGNATION','BR',0,'C');
					$pdf->Cell(3.63,1,'VALEURS NETTES $','BR',0,'C');

					$pdf->Ln();
					$pdf->SetFont('Times','','9');
					$pdf->Cell(3.38,1,'','LBR',0,'C');
					$pdf->Cell(3.38,1,'ACTIFS IMMOBILISES','BR',0,'C');
					$pdf->Cell(3.38,1,'','BR',0,'C');
					$pdf->Cell(3.38,1,'','BR',0,'C');
					$pdf->Cell(3.38,1,'','BR',0,'C');
					$pdf->Cell(3.63,1,'','BR',0,'C');
					$pdf->Cell(3.63,1,'RESSOURCES PROPRES','BR',0,'C');
					$pdf->Cell(3.63,1,'','BR',0,'C');
					$pdf->Ln();

					for ($i=0; $i < $index_for_group_1 ; $i++) { 

						if(isset($actifs_immobilises_array[$i])){
							$pdf->Cell(3.38,1,$actifs_immobilises_array[$i]['code_comptable'],'LBRT',0,'C');
							$pdf->Cell(3.38,1,ellipsis( iconv('UTF-8','windows-1252',$actifs_immobilises_array[$i]['designation_sous_categorie_plan_comptable']),20),'BRT',0,'C');
							$pdf->Cell(3.38,1,number_format($actifs_immobilises_array[$i]['total_sortie'],2),'BRT',0,'C');
							$pdf->Cell(3.38,1,number_format($actifs_immobilises_array[$i]['total_entree'],2),'BRT',0,'C');
							$pdf->Cell(3.38,1,number_format($actifs_immobilises_array[$i]['solde_restant'],2),'BRT',0,'C');
						}else{
							$pdf->Cell(3.38,1,'','LBRT',0,'C');
							$pdf->Cell(3.38,1,'','BRT',0,'C');
							$pdf->Cell(3.38,1,'','BRT',0,'C');
							$pdf->Cell(3.38,1,'','BRT',0,'C');
							$pdf->Cell(3.38,1,'','BRT',0,'C');
						}


						if(isset($capitaux_propres_array[$i])){
							$pdf->Cell(3.63,1,$capitaux_propres_array[$i]['code_comptable'],'BRT',0,'C');
							$pdf->Cell(3.63,1,ellipsis(iconv('UTF-8','windows-1252',$capitaux_propres_array[$i]['designation_sous_categorie_plan_comptable']),20),'BRT',0,'C');
							$pdf->Cell(3.63,1,number_format($capitaux_propres_array[$i]['solde_restant'],2),'BRT',0,'C');
						}else{
							
							if( $i == count($capitaux_propres_array)-3){
								$pdf->Cell(3.63,1,'1310','BRT',0,'C');
								$pdf->Cell(3.63,1,iconv('UTF-8','windows-1252','Résultat Net'),'BRT',0,'C');
								$pdf->Cell(3.63,1,number_format($compte_resultat_array['solde'], 2),'BRT',0,'C');
							}else{ 
								$pdf->Cell(3.63,1,'','BRT',0,'C');
								$pdf->Cell(3.63,1,'','BRT',0,'C');
								$pdf->Cell(3.63,1,'','BRT',0,'C');
							}
						}
						$pdf->Ln();
					}

					if( count($capitaux_propres_array ) >= count($actifs_immobilises_array) ){
						$pdf->Cell(3.38,1,'','LBRT',0,'C');
						$pdf->Cell(3.38,1,'','BRT',0,'C');
						$pdf->Cell(3.38,1,'','BRT',0,'C');
						$pdf->Cell(3.38,1,'','BRT',0,'C');
						$pdf->Cell(3.38,1,'','BRT',0,'C');
						$pdf->Cell(3.63,1,'1310','BRT',0,'C');
						$pdf->Cell(3.63,1,iconv('UTF-8','windows-1252','Résultat Net'),'BRT',0,'C');
						$pdf->Cell(3.63,1,number_format($compte_resultat_array['solde'], 2),'BRT',0,'C');
						$pdf->Ln();
					}

					$pdf->Cell(3.38,1,'','LBRT',0,'C');
					$pdf->Cell(3.38,1,'TOTAL ACT.IMM','BR',0,'C');
					$pdf->Cell(3.38,1,number_format($actifs_immobilises_array['total_sorties'],2),'BRT',0,'C');
					$pdf->Cell(3.38,1,number_format($actifs_immobilises_array['total_entrees'],2),'BRT',0,'C');
					$pdf->Cell(3.38,1,number_format($actifs_immobilises_array['solde'],2),'BR',0,'C');
					$pdf->Cell(3.63,1,'','BRT',0,'C');
					$pdf->Cell(3.63,1,'TOTAL RESS. PROPRES','BR',0,'C');
					$pdf->Cell(3.63,1,number_format($capitaux_propres_array['solde'], 2),'BRT',0,'C');
					$pdf->Ln();

					$pdf->Cell(3.38,1,'','LBRT',0,'C');
					$pdf->Cell(3.38,1,'ACTIFS CIRCULANTS','BRT',0,'C');
					$pdf->Cell(3.38,1,'','BRT',0,'C');
					$pdf->Cell(3.38,1,'','BRT',0,'C');
					$pdf->Cell(3.38,1,'','BRT',0,'C');
					$pdf->Cell(3.63,1,'','BRT',0,'C');
					$pdf->Cell(3.63,1,'PASSIF CIRCULANTS','BRT',0,'C');
					$pdf->Cell(3.63,1,'','BR',0,'C');
					$pdf->Ln();

					for ($i=0; $i < $index_for_group_2 ; $i++) { 

						if(isset($actifs_circulants_array[$i])){
							$pdf->Cell(3.38,1,$actifs_circulants_array[$i]['code_comptable'],'LBRT',0,'C');
							$pdf->Cell(3.38,1,ellipsis( iconv('UTF-8','windows-1252',$actifs_circulants_array[$i]['designation_sous_categorie_plan_comptable']),20),'BRT',0,'C');
							$pdf->Cell(3.38,1,number_format($actifs_circulants_array[$i]['total_sortie'],2),'BRT',0,'C');
							$pdf->Cell(3.38,1,number_format($actifs_circulants_array[$i]['total_entree'],2),'BRT',0,'C');
							$pdf->Cell(3.38,1,number_format($actifs_circulants_array[$i]['solde_restant'],2),'BRT',0,'C');
						}else{
							$pdf->Cell(3.38,1,'','LBRT',0,'C');
							$pdf->Cell(3.38,1,'','BRT',0,'C');
							$pdf->Cell(3.38,1,'','BRT',0,'C');
							$pdf->Cell(3.38,1,'','BRT',0,'C');
							$pdf->Cell(3.38,1,'','BRT',0,'C');
						}


						if(isset($passifs_circulants_array[$i])){
							$pdf->Cell(3.63,1,$passifs_circulants_array[$i]['code_comptable'],'BRT',0,'C');
							$pdf->Cell(3.63,1,ellipsis(iconv('UTF-8','windows-1252',$passifs_circulants_array[$i]['designation_sous_categorie_plan_comptable']),20),'BRT',0,'C');
							$pdf->Cell(3.63,1,number_format($passifs_circulants_array[$i]['solde_restant'],2),'BRT',0,'C');
						}else{
							$pdf->Cell(3.63,1,'','BRT',0,'C');
							$pdf->Cell(3.63,1,'','BRT',0,'C');
							$pdf->Cell(3.63,1,'','BRT',0,'C');
						}
						$pdf->Ln();
					}


					$pdf->Cell(3.38,1,'','LBRT',0,'C');
					$pdf->Cell(3.38,1,'TOTAL ACT.CIRC','BRT',0,'C');
					$pdf->Cell(3.38,1,number_format($actifs_circulants_array['total_sorties'],2),'BRT',0,'C');
					$pdf->Cell(3.38,1,number_format($actifs_circulants_array['total_entrees'],2),'BRT',0,'C');
					$pdf->Cell(3.38,1,number_format($actifs_circulants_array['solde'],2),'BR',0,'C');
					$pdf->Cell(3.63,1,'','BR',0,'C');
					$pdf->Cell(3.63,1,'TOTAL PASS.CIRC','BRT',0,'C');
					$pdf->Cell(3.63,1,number_format($passifs_circulants_array['solde'], 2),'BRT',0,'C');
					$pdf->Ln();


					$pdf->Cell(3.38,1,'','LBRT',0,'C');
					$pdf->Cell(3.38,1,'TRESORERIE ACT','TBR',0,'C');
					$pdf->Cell(3.38,1,'','TBR',0,'C');
					$pdf->Cell(3.38,1,'','TBR',0,'C');
					$pdf->Cell(3.38,1,'','TBR',0,'C');
					$pdf->Cell(3.63,1,'','TBR',0,'C');
					$pdf->Cell(3.63,1,'TRESORERIE PASS','TBR',0,'C');
					$pdf->Cell(3.63,1,'','TBR',0,'C');
					$pdf->Ln();

					$pdf->Cell(3.38,1,'5200','LBRT',0,'C');
					$pdf->Cell(3.38,1,'Banque','BRT',0,'C');
					$pdf->Cell(3.38,1, number_format($tresoreries_actifs_array['solde_banque'], 2) ,'BRT',0,'C');
					$pdf->Cell(3.38,1,0,'BR',0,'C');
					$pdf->Cell(3.38,1, number_format($tresoreries_actifs_array['solde_banque'], 2) ,'BRT',0,'C');
					$pdf->Cell(3.63,1,'','BRT',0,'C');
					$pdf->Cell(3.63,1,'','BRT',0,'C');
					$pdf->Cell(3.63,1,'','BRT',0,'C');
					$pdf->Ln();

					$pdf->Cell(3.38,1,'5700','LBRT',0,'C');
					$pdf->Cell(3.38,1,'Caisse','BRT',0,'C');
					$pdf->Cell(3.38,1,  number_format($tresoreries_actifs_array['solde_caise'], 2) ,'BRT',0,'C');
					$pdf->Cell(3.38,1,0,'BRT',0,'C');
					$pdf->Cell(3.38,1,  number_format($tresoreries_actifs_array['solde_caise'], 2) ,'BRT',0,'C');
					$pdf->Cell(3.63,1,'','BRT',0,'C');
					$pdf->Cell(3.63,1,'','BRT',0,'C');
					$pdf->Cell(3.63,1,'','BRT',0,'C');
					$pdf->Ln();

					$pdf->Cell(3.38,1,'','LBRT',0,'C');
					$pdf->Cell(3.38,1,'TOTAL TRES.ACT','BRT',0,'C');
					$pdf->Cell(3.38,1,number_format($tresoreries_actifs_array['solde'], 2),'BRT',0,'C');
					$pdf->Cell(3.38,1,number_format(0,2),'BRT',0,'C');
					$pdf->Cell(3.38,1,number_format($tresoreries_actifs_array['solde'], 2),'BRT',0,'C');
					$pdf->Cell(3.63,1,'','BRT',0,'C');
					$pdf->Cell(3.63,1,'TOTAL TRES.PASS','BRT',0,'C');
					$pdf->Cell(3.63,1,number_format(0, 2),'BRT',0,'C');
					$pdf->Ln();


					$pdf->SetFillColor(166,166,166);
					$pdf->SetTextColor(0,32,96);
					$pdf->SetFont('Times','B','12');

					$pdf->Cell(3.38,1,'','LBRT',0,'C');
					$pdf->Cell(3.38,1,'Total Actif','BRT',0,'C');
					$pdf->Cell(3.38,1,number_format($total_actifs_valeurs_brutes, 2) ,'BRT',0,'C');
					$pdf->Cell(3.38,1,number_format($total_actifs_am_pro, 2),'BRT',0,'C');
					$pdf->Cell(3.38,1,number_format($total_actifs_valeurs_nettes, 2) ,'BRT',0,'C');
					$pdf->Cell(3.63,1,'','BRT',0,'C');
					$pdf->Cell(3.63,1,'Total Passif','BRT',0,'C');
					$pdf->Cell(3.63,1,number_format($total_passifs, 2),'BRT',0,'C');

					
					$pdf->Output('D',$file_export_name);

				}

				
			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}

		}else {
			redirect("Starter/login");
		}
	
	}

	public function bilan_export_simple($id_year=null,$id_entreprise_salesienne_in=null)
	{
		if(  $this->session->logged_in ){
			if(check_privilege('bilan', $this->session->user['id_role'], 'voir')){

				$entreprise_salesienne      = [];
				$id_entreprise_salesienne 	= ((int) $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0) ? 'situation de la province' : (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] ;
				$sous_comptable_affectee 	= null;
				$annee_excerice 			= null;
				$annee_excerice_next 		= null;
				$capitaux_propres_array		= [];
				$compte_resultat_array		= [];
				$total_passifs		 	  = 0;
				$id_year 				  = ($id_year == null AND !isset($id_year) ) ? date('Y') : $id_year;
				$bilan_start_date 		  = '';
				$bilan_end_date 		  = '';


				if($id_entreprise_salesienne_in<>null){
					$_POST['id_entreprise_salesienne'] = urldecode($id_entreprise_salesienne_in);
				}

				if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0  AND !isset($_POST['id_entreprise_salesienne']) ){
					$_POST['id_entreprise_salesienne'] = $id_entreprise_salesienne;
				}
				
				
				if( isset( $_POST['annee_exercice'] )  OR ( isset($id_year) AND $id_year <> null ) ){
						
					$annee_excerice 	 	 =  ( isset($_POST['annee_exercice']) ) ? $_POST['annee_exercice'] : $id_year;
					$_POST['annee_exercice'] =  ( isset($_POST['annee_exercice']) ) ? $_POST['annee_exercice'] : $id_year;
					$annee_excerice_next 	 =  (int) $annee_excerice + 1;
					$bilan_start_date 		 = $annee_excerice.'09/01';
					$bilan_end_date 		 = $annee_excerice_next.'/08/31';

					$sql 				=" date_enregistrement_livre_caisse_banque BETWEEN '".$bilan_start_date."' AND '".$bilan_end_date."'";
					$sql_amortissement 	=" date_enregistrement_livre_caisse_banque <= '$bilan_end_date' ";
					$sql_caisse_banque 	=" id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
					
					
					
					if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] <> 'null'){

						if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne']  <> 0){
							$sql 				.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
							$sql_amortissement 	.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
							$sql_caisse_banque 	=" id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
						}else{
							if( $_POST['id_entreprise_salesienne'] <> 'situation de la province'){
								$sql 				.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$_POST['id_entreprise_salesienne']."";
								$sql_amortissement	.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque =".$_POST['id_entreprise_salesienne']."";
								$sql_caisse_banque  =" id_foreign_entreprise_salesienne_livre_caisse_banque =".$_POST['id_entreprise_salesienne']."";
							}
						}
						$id_entreprise_salesienne = $_POST['id_entreprise_salesienne'];
					}else{
						if( $_SESSION['user']['id_foreign_entreprise_salesienne'] <> 0 ){
							$sql 				.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
							$sql_amortissement 	.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
							$sql_caisse_banque 	.=" AND id_foreign_entreprise_salesienne_livre_caisse_banque = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
						}
					}


					if(  isset( $_POST['id_entreprise_salesienne'] ) AND ($_POST['id_entreprise_salesienne'] == 'situation de la province') ){
						$entreprise_salesienne['nom_entreprise_salesienne'] = 'situation de la province';
						$entreprise_salesienne['id_entreprise_salesienne']  = 'situation de la province';
					}else{
						$entreprise_salesienne = $this->Entreprise_salesienne_model->get_entreprise_salesienne($id_entreprise_salesienne);
					}

					

					$sous_comptable_affectee 		= $this->_build_sous_cat_plan_comptable_array($id_entreprise_salesienne);
					$actifs_immobilises_array 		= $this->_build_actifs_immobilises_array($sous_comptable_affectee,$sql_amortissement);
					$actifs_circulants_array 		= $this->_build_actifs_circulants_array($sous_comptable_affectee,$sql_amortissement);
					$tresoreries_actifs_array 		= $this->_build_tresoreries_actifs($sous_comptable_affectee,$sql_amortissement);
					$capitaux_propres_array 		= $this->_build_capitaux_propres_array($sous_comptable_affectee,$sql_amortissement);
					$passifs_circulants_array	 	= $this->_build_passifs_circulants_array($sous_comptable_affectee,$sql_amortissement);
					$compte_resultat_array		 	= $this->_build_compte_resultat_array($sous_comptable_affectee,$sql);

					if( (int) $compte_resultat_array['solde'] == 0){
						$year	= $annee_excerice - 1;
						$sql 	= str_replace($annee_excerice.'/09/01',$year.'/09/01',$sql);
						$sql 	= str_replace(($annee_excerice+1).'/08/31',$annee_excerice.'/08/31',$sql);
						$compte_resultat_array		 	= $this->_build_compte_resultat_array($sous_comptable_affectee,$sql);
					}

					$total_solde_caisse 		 = $this->_build_disponible_caisse_array($sous_comptable_affectee,$sql);
					$total_solde_banque 		 = $this->_build_disponible_banque_array($sous_comptable_affectee,$sql);
					$total_actifs_valeurs_brutes = $actifs_immobilises_array['total_sorties'] + $actifs_circulants_array['total_sorties'] + $tresoreries_actifs_array ['solde'];
					$total_actifs_am_pro 		 = $actifs_immobilises_array['total_entrees'] + $actifs_circulants_array['total_entrees'];
					$total_actifs_valeurs_nettes = $actifs_immobilises_array['solde'] + $actifs_circulants_array['solde']+ $tresoreries_actifs_array ['solde'];
					$total_passifs 				 = $capitaux_propres_array['solde'] + $passifs_circulants_array['solde'] + $compte_resultat_array['solde'];
					$file_export_name 			 = 'Bilan '.$entreprise_salesienne['nom_entreprise_salesienne'].' simplifié exercice '.$annee_excerice.'.pdf';
					$index_for_group_1 			 = ( count($actifs_immobilises_array) >= count($capitaux_propres_array) ) ? count($actifs_immobilises_array)-3 : count($capitaux_propres_array)-3; 
					$index_for_group_2 			 = ( count($actifs_circulants_array) >= count($passifs_circulants_array) ) ? count($actifs_circulants_array)-3 : count($passifs_circulants_array)-3; 

					$pdf = new FPDF('L','cm','A4');

					$pdf->AddPage();
					$pdf->SetAutoPageBreak(true,2);

					$pdf->SetTextColor(0,32,96);
					$pdf->SetFont('Times','','14');

					$pdf->Cell(27.8,1.5,iconv('UTF-8','windows-1252',strtoupper( 'Bilan '.$entreprise_salesienne['nom_entreprise_salesienne'].' SIMPLIFIE exercice '.$annee_excerice )),'',1,'L');
					$pdf->Image(base_url('assets/dore_assets').'/img/logo_salesien_bg.png',25,0.1,2.5,2.5);

					$pdf->SetFillColor(0,32,96);
					$pdf->SetTextColor(255,255,255);
					$pdf->SetFont('Times','','12');

					$pdf->Cell(16.9,1.5,'ACTIF','LTB',0,'C',true);
					$pdf->Cell(10.9,1.5,'PASSIF','TRB',1,'C',true);

					$pdf->SetTextColor(0,0,0);
					$pdf->SetFont('Times','','10');

					for ($i=0; $i < $index_for_group_1 ; $i++) { 

						if(isset($actifs_immobilises_array[$i])){
							$pdf->Cell(8.45,1,ellipsis( iconv('UTF-8','windows-1252',$actifs_immobilises_array[$i]['designation_sous_categorie_plan_comptable']),40),'LBT',0,'L');
							$pdf->Cell(8.45,1,number_format($actifs_immobilises_array[$i]['solde_restant'],2),'BRT',0,'R');
						}else{
							$pdf->Cell(8.45,1,'','LBT',0,'L');
							$pdf->Cell(8.45,1,'','BRT',0,'R');
						}


						if(isset($capitaux_propres_array[$i])){
							$pdf->Cell(5.45,1,ellipsis(iconv('UTF-8','windows-1252',$capitaux_propres_array[$i]['designation_sous_categorie_plan_comptable']),40),'LBT',0,'L');
							$pdf->Cell(5.45,1,number_format($capitaux_propres_array[$i]['solde_restant'],2),'BRT',0,'R');
						}else{
							
							if( $i == count($capitaux_propres_array)-3){
								$pdf->Cell(5.45,1,iconv('UTF-8','windows-1252','Résultat Net'),'LBT',0,'L');
								$pdf->Cell(5.45,1,number_format($compte_resultat_array['solde'], 2),'BRT',0,'R');
							}else{ 
								$pdf->Cell(5.45,1,'','LBT',0,'L');
								$pdf->Cell(5.45,1,'','BRT',0,'R');
							}
						}
						$pdf->Ln();
					}

					if( count($capitaux_propres_array ) >= count($actifs_immobilises_array) ){
						$pdf->Cell(8.45,1,'','LBT',0,'L');
						$pdf->Cell(8.45,1,'','BRT',0,'R');
						$pdf->Cell(5.45,1,iconv('UTF-8','windows-1252','Résultat Net'),'LBT',0,'L');
						$pdf->Cell(5.45,1,number_format($compte_resultat_array['solde'], 2),'BRT',0,'R');
						$pdf->Ln();
					}


					$pdf->Cell(8.45,1,'---','LBT',0,'L');
					$pdf->Cell(8.45,1,'---','BRT',0,'R');
					$pdf->Cell(5.45,1,'---','LBT',0,'L');
					$pdf->Cell(5.45,1,'---','BRT',0,'R');
					$pdf->Ln();



					for ($i=0; $i < $index_for_group_2 ; $i++) { 

						if(isset($actifs_circulants_array[$i])){
							$pdf->Cell(8.45,1,ellipsis( iconv('UTF-8','windows-1252',$actifs_circulants_array[$i]['designation_sous_categorie_plan_comptable']),20),'LBTT',0,'L');
							$pdf->Cell(8.45,1,number_format($actifs_circulants_array[$i]['solde_restant'],2),'BRT',0,'R');
						}else{
							$pdf->Cell(8.45,1,'','LBT',0,'L');
							$pdf->Cell(8.45,1,'','BRT',0,'R');
						}


						if(isset($passifs_circulants_array[$i])){
							$pdf->Cell(5.45,1,ellipsis(iconv('UTF-8','windows-1252',$passifs_circulants_array[$i]['designation_sous_categorie_plan_comptable']),20),'LBT',0,'L');
							$pdf->Cell(5.45,1,number_format($passifs_circulants_array[$i]['solde_restant'],2),'BRT',0,'R');
						}else{
							$pdf->Cell(5.45,1,'','LBT',0,'L');
							$pdf->Cell(5.45,1,'','BRT',0,'R');
						}
						$pdf->Ln();
					}


					$pdf->Cell(8.45,1,'---','LBT',0,'L');
					$pdf->Cell(8.45,1,'---','BRT',0,'R');
					$pdf->Cell(5.45,1,'---','LBT',0,'L');
					$pdf->Cell(5.45,1,'---','BRT',0,'R');
					$pdf->Ln();

					$pdf->Cell(8.45,1,'Banque','LBT',0,'L');
					$pdf->Cell(8.45,1, number_format($tresoreries_actifs_array['solde_banque'], 2) ,'BRT',0,'R');
					$pdf->Cell(5.45,1,'','LBT',0,'L');
					$pdf->Cell(5.45,1,'','BRT',0,'R');
					$pdf->Ln();

					$pdf->Cell(8.45,1,'Caisse','LBT',0,'L');
					$pdf->Cell(8.45,1, number_format($tresoreries_actifs_array['solde_caise'], 2) ,'BRT',0,'R');
					$pdf->Cell(5.45,1,'','LBT',0,'L');
					$pdf->Cell(5.45,1,'','BRT',0,'R');
					$pdf->Ln();


					$pdf->Cell(8.45,1,'---','LBT',0,'L');
					$pdf->Cell(8.45,1,'---','BRT',0,'R');
					$pdf->Cell(5.45,1,'---','LBT',0,'L');
					$pdf->Cell(5.45,1,'---','BRT',0,'R');
					$pdf->Ln();
					

					$pdf->SetFillColor(166,166,166);
					$pdf->SetTextColor(0,32,96);
					$pdf->SetFont('Times','B','12');

					$pdf->Cell(8.45,1,'Total Actif','LBT',0,'L');
					$pdf->Cell(8.45,1, number_format($total_actifs_valeurs_nettes, 2) ,'BRT',0,'R');

					$pdf->Cell(5.45,1,'Total Passif','LBT',0,'L');
					$pdf->Cell(5.45,1,number_format($total_passifs, 2),'BRT',0,'R');
					
					$pdf->Output('D',$file_export_name);

				}

				
			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}

		}else {
			redirect("Starter/login");
		}
	
	}

	public function _build_sous_cat_plan_comptable_array($id_user_entreprise){

		$sous_categorie_affectee_result = [];
		$ids_sous_categorie_affectees 	= [];

		if($id_user_entreprise == "situation de la province"){
			$sous_categorie_affectees 		= $this->Sous_categorie_affectee_model->get_all_sous_categorie_comptable_affectees();
			$ids_sous_categorie_comptable_affectees = '';

			foreach ($sous_categorie_affectees as $key => $sous_categorie_affectee) {
				$ids_sous_categorie_comptable_affectees.= $sous_categorie_affectee['id_foreign_sous_categorie'].',';
			}
			$ids_sous_categorie_comptable_affectees = substr($ids_sous_categorie_comptable_affectees,0,-1);
			$tab_ids_sous_categorie_comptable_affectees = explode(',',$ids_sous_categorie_comptable_affectees);
			$tab_ids_sous_categorie_comptable_affectees = array_unique($tab_ids_sous_categorie_comptable_affectees);
			sort($tab_ids_sous_categorie_comptable_affectees);

			$ids_sous_categorie_comptable_affectees = implode(',', $tab_ids_sous_categorie_comptable_affectees);
			$sous_categorie_affectees = [];

			$sous_categorie_affectees [0] = [
				'id_sous_categorie_comptable_affectee'=>1,
				'id_foreign_sous_categorie'=> $ids_sous_categorie_comptable_affectees,
				'id_foreign_entreprise_salesienne'=>32
			];
		
		}else{
			$sous_categorie_affectees 		= $this->Sous_categorie_affectee_model->get_sous_categorie_comptable_affectee_by_id_entreprise($id_user_entreprise);
		}

		if(!empty( $sous_categorie_affectees) ){
			foreach ($sous_categorie_affectees as $key => $sous_categorie_affectee) {
				$ids_sous_categorie_affectees = explode(',',$sous_categorie_affectee['id_foreign_sous_categorie']);
				$entreprise_salesienne 			= $this->Entreprise_salesienne_model->get_entreprise_salesienne($sous_categorie_affectee['id_foreign_entreprise_salesienne']);
				foreach ($ids_sous_categorie_affectees as $key => $id_sous_categorie_affectees) {
					$sous_categorie = $this->Sous_categorie_model->get_sous_categorie_comptable($id_sous_categorie_affectees);
					if(!empty($sous_categorie)){
						$sous_categorie['nom_entreprise_salesienne'] = $entreprise_salesienne['nom_entreprise_salesienne'];
						$sous_categorie_affectee_result[]  = $sous_categorie;
					}
				}
			}
		}

		return $sous_categorie_affectee_result;
	}

	public function _build_compte_resultat_array($sous_categorie_plan_comptables , $sql = null)
	{
		$categorie_sous_cat_comptables_results = [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			

			if( (int) $sous_categorie_plan_comptable['code_comptable'] >=6000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 7999 ){
				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
			}

		}
		$categorie_sous_cat_comptables_results['total_entrees'] =  $total_entrees;
		$categorie_sous_cat_comptables_results['total_sorties'] =  $total_sorties;
		$categorie_sous_cat_comptables_results['solde'] =  $total_entrees - $total_sorties;
		return $categorie_sous_cat_comptables_results;
	}
	
	public function _build_actifs_immobilises_array($sous_categorie_plan_comptables, $sql =null)
	{
		$imm_corporelle_array 	= [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			
			if( (int) $sous_categorie_plan_comptable['code_comptable'] >=2000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 2999 ){

				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				$sous_categorie_plan_comptable['solde_restant']		=  $sous_categorie_plan_comptable['total_sortie'] - $sous_categorie_plan_comptable['total_entree'] ;
				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
				 
				$imm_corporelle_array [] = $sous_categorie_plan_comptable;
			}
		}

		$key_values = array_column($imm_corporelle_array, 'code_comptable'); 
		array_multisort($key_values, SORT_ASC, $imm_corporelle_array);
		
		$imm_corporelle_array =  $this->format_array($imm_corporelle_array);
		$imm_corporelle_array['total_entrees'] =  $total_entrees;
		$imm_corporelle_array['total_sorties'] =  $total_sorties;
		$imm_corporelle_array['solde'] =  $total_sorties - $total_entrees;
		return $imm_corporelle_array;
	}

	public function _build_actifs_circulants_array($sous_categorie_plan_comptables, $sql =null)
	{
		$imm_incorporelle_array = [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			
			if( ( (int) $sous_categorie_plan_comptable['code_comptable'] >=3000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 3999 ) OR ( (int) $sous_categorie_plan_comptable['code_comptable'] >=4100 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 4199 ) )
			{

				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				$sous_categorie_plan_comptable['solde_restant']		=  $sous_categorie_plan_comptable['total_sortie'] - $sous_categorie_plan_comptable['total_entree'] ;
				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
				$imm_incorporelle_array [] = $sous_categorie_plan_comptable;
			}
		}

		$key_values = array_column($imm_incorporelle_array, 'code_comptable'); 
		array_multisort($key_values, SORT_ASC, $imm_incorporelle_array);

		$imm_incorporelle_array =  $this->format_array($imm_incorporelle_array);
		$imm_incorporelle_array['total_entrees'] =  $total_entrees;
		$imm_incorporelle_array['total_sorties'] =  $total_sorties;
		$imm_incorporelle_array['solde'] =  $total_sorties - $total_entrees;
		return $imm_incorporelle_array;
	}

	public function _build_tresoreries_actifs($sous_categorie_plan_comptables, $sql =null)
	{
		$am_pro_array = [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			
			if( ( (int) $sous_categorie_plan_comptable['code_comptable'] >=5200 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 5299) OR ((int) $sous_categorie_plan_comptable['code_comptable'] >=5700 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 5799) ){

				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				$sous_categorie_plan_comptable['solde_restant']		=  $sous_categorie_plan_comptable['total_sortie'] - $sous_categorie_plan_comptable['total_entree'] ;
				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
				$am_pro_array [] = $sous_categorie_plan_comptable;
			}
		}

		$key_values = array_column($am_pro_array, 'code_comptable'); 
		array_multisort($key_values, SORT_ASC, $am_pro_array);

		$am_pro_array['total_entrees'] =  $total_entrees;
		$am_pro_array['total_sorties'] =  $total_sorties;
		$am_pro_array['solde_trx'] =  $total_sorties - $total_entrees;
		$am_pro_array['solde_caise'] = 0;
		$am_pro_array['solde_banque'] = 0;

		if(!str_contains($sql,'id_foreign_entreprise_salesienne_livre_caisse_banque')){
			$entreprises_salesiennes = $this->Entreprise_salesienne_model->get_all_entreprise_salesiennes();
			if(!empty($entreprises_salesiennes)){
				foreach ($entreprises_salesiennes as $key => $entreprise_salesienne) {
					$sql.= ' AND id_foreign_entreprise_salesienne_livre_caisse_banque ='.$entreprise_salesienne['id_entreprise_salesienne'];
					$am_pro_array['solde_caise'] = $am_pro_array['solde_caise'] + $this->_build_solde_caisse($sql);
					$am_pro_array['solde_banque'] = $am_pro_array['solde_banque'] + $this->_build_solde_banque($sql);
					$sql = str_replace( ' AND id_foreign_entreprise_salesienne_livre_caisse_banque ='.$entreprise_salesienne['id_entreprise_salesienne'],'',$sql);
				}
			}
		}else{
			$am_pro_array['solde_caise'] = $this->_build_solde_caisse($sql);
			$am_pro_array['solde_banque'] = $this->_build_solde_banque($sql);
		}

		$am_pro_array['solde'] = $am_pro_array['solde_caise'] + $am_pro_array['solde_banque'] ;

		return $am_pro_array;
	}

	public function _build_capitaux_propres_array($sous_categorie_plan_comptables, $sql =null)
	{
		$capitaux_propres = [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			
			if( (int) $sous_categorie_plan_comptable['code_comptable'] >=1000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 1499  AND (int) $sous_categorie_plan_comptable['code_comptable'] <>1310  ){

				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				$sous_categorie_plan_comptable['solde_restant']		=   $sous_categorie_plan_comptable['total_sortie'] - $sous_categorie_plan_comptable['total_entree'];
				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
				$capitaux_propres [] = $sous_categorie_plan_comptable;
			}
		}

		$key_values = array_column($capitaux_propres, 'code_comptable'); 
		array_multisort($key_values, SORT_ASC, $capitaux_propres);

		$capitaux_propres =  $this->format_array($capitaux_propres);
		$capitaux_propres['total_entrees'] 	=  $total_entrees;
		$capitaux_propres['total_sorties'] 	=  $total_sorties;
		$capitaux_propres['solde'] 			=   $total_sorties - $total_entrees ;
		return $capitaux_propres;
	}

	public function _build_passifs_circulants_array($sous_categorie_plan_comptables, $sql =null)
	{
		$capitaux_permanents = [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			
			if( ( (int) $sous_categorie_plan_comptable['code_comptable'] >=4000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 4099 ) OR ( (int) $sous_categorie_plan_comptable['code_comptable'] >=4200 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 4999 )  ){

				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				$sous_categorie_plan_comptable['solde_restant']		=  $sous_categorie_plan_comptable['total_sortie'] - $sous_categorie_plan_comptable['total_entree'];
				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
				$capitaux_permanents [] = $sous_categorie_plan_comptable;
			}
		}

		$key_values = array_column($capitaux_permanents, 'code_comptable'); 
		array_multisort($key_values, SORT_ASC, $capitaux_permanents);

		$capitaux_permanents =  $this->format_array($capitaux_permanents);
		$capitaux_permanents['total_entrees'] =  $total_entrees;
		$capitaux_permanents['total_sorties'] =  $total_sorties;
		$capitaux_permanents['solde'] =   $total_sorties - $total_entrees ;
		return $capitaux_permanents;
	}

	public function _build_actif_circulant_cat_trois_array($sous_categorie_plan_comptables, $sql =null)
	{
		$actif_circulant_trois = [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			
			if( ( (int) $sous_categorie_plan_comptable['code_comptable'] >=3000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 3799 ) OR ( (int) $sous_categorie_plan_comptable['code_comptable'] >=3900 AND (int) $sous_categorie_plan_comptable['code_comptable'] <=3999 ) ){

				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				$sous_categorie_plan_comptable['solde_restant']		=  $sous_categorie_plan_comptable['total_sortie'] - $sous_categorie_plan_comptable['total_entree'] ;
				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
				$actif_circulant_trois [] = $sous_categorie_plan_comptable;
			}
		}
		$actif_circulant_trois['total_entrees'] =  $total_entrees;
		$actif_circulant_trois['total_sorties'] =  $total_sorties;
		$actif_circulant_trois['solde'] =  $total_sorties - $total_entrees;
		return $actif_circulant_trois;
	}

	public function _build_actif_circulant_provision_cat_trois_array($sous_categorie_plan_comptables, $sql =null)
	{
		$actif_circulant_provision_trois = [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			
			if( (int) $sous_categorie_plan_comptable['code_comptable'] >=3800 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 3899 ){

				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				$sous_categorie_plan_comptable['solde_restant']		=  $sous_categorie_plan_comptable['total_sortie'] - $sous_categorie_plan_comptable['total_entree'] ;
				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
				$actif_circulant_provision_trois [] = $sous_categorie_plan_comptable;
			}
		}
		$actif_circulant_provision_trois['total_entrees'] =  $total_entrees;
		$actif_circulant_provision_trois['total_sorties'] =  $total_sorties;
		$actif_circulant_provision_trois['solde'] =  $total_sorties - $total_entrees;
		return $actif_circulant_provision_trois;
	}

	public function _build_actif_circulant_cat_quatre_array($sous_categorie_plan_comptables, $sql =null)
	{
		$actif_circulant_quatre = [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			
			if( ( (int) $sous_categorie_plan_comptable['code_comptable'] >=4100 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 4199) ){

				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				$sous_categorie_plan_comptable['solde_restant']		=  $sous_categorie_plan_comptable['total_sortie'] - $sous_categorie_plan_comptable['total_entree'] ;
				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
				$actif_circulant_quatre [] = $sous_categorie_plan_comptable;
			}
		}
		$actif_circulant_quatre['total_entrees'] =  $total_entrees;
		$actif_circulant_quatre['total_sorties'] =  $total_sorties;
		$actif_circulant_quatre['solde'] =  $total_sorties - $total_entrees;
		return $actif_circulant_quatre;
	}

	public function _build_actif_circulant_provision_cat_quatre_array($sous_categorie_plan_comptables, $sql =null)
	{
		$actif_provision_circulant_quatre = [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			
			if( (int) $sous_categorie_plan_comptable['code_comptable'] >=4800 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 4899 ){

				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				$sous_categorie_plan_comptable['solde_restant']		=  $sous_categorie_plan_comptable['total_sortie'] - $sous_categorie_plan_comptable['total_entree'] ;
				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
				$actif_provision_circulant_quatre [] = $sous_categorie_plan_comptable;
			}
		}
		$actif_provision_circulant_quatre['total_entrees'] =  $total_entrees;
		$actif_provision_circulant_quatre['total_sorties'] =  $total_sorties;
		$actif_provision_circulant_quatre['solde'] =  $total_sorties - $total_entrees;
		return $actif_provision_circulant_quatre;
	}

	public function _build_actif_circulant_provision_cat_cinq_array($sous_categorie_plan_comptables, $sql =null)
	{
		$actif_provision_circulant_cinq = [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			
			if( (int) $sous_categorie_plan_comptable['code_comptable'] >=5800 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 5899 ){

				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				$sous_categorie_plan_comptable['solde_restant']		=  $sous_categorie_plan_comptable['total_sortie'] - $sous_categorie_plan_comptable['total_entree'] ;
				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
				$actif_provision_circulant_cinq [] = $sous_categorie_plan_comptable;
			}
		}
		$actif_provision_circulant_cinq['total_entrees'] =  $total_entrees;
		$actif_provision_circulant_cinq['total_sorties'] =  $total_sorties;
		$actif_provision_circulant_cinq['solde'] =  $total_sorties - $total_entrees;
		return $actif_provision_circulant_cinq;
	}

	public function _build_passif_circulant_cat_quatre_array($sous_categorie_plan_comptables, $sql =null)
	{
		$actif_circulant_quatre = [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			
			if( 
				( (int) $sous_categorie_plan_comptable['code_comptable'] >=4000 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 4099 )
				OR
				( (int) $sous_categorie_plan_comptable['code_comptable'] >=4200 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 4999 )
			  )
			{

				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				$sous_categorie_plan_comptable['solde_restant']		=  $sous_categorie_plan_comptable['total_sortie'] - $sous_categorie_plan_comptable['total_entree'] ;
				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
				$actif_circulant_quatre [] = $sous_categorie_plan_comptable;
			}
		}
		$actif_circulant_quatre['total_entrees'] =  $total_entrees;
		$actif_circulant_quatre['total_sorties'] =  $total_sorties;
		$actif_circulant_quatre['solde'] =  $total_sorties - $total_entrees;
		return $actif_circulant_quatre;
	}


	public function _build_disponible_banque_array($sous_categorie_plan_comptables, $sql =null)
	{
		$disponible_banque_array = [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			
			if( ( (int) $sous_categorie_plan_comptable['code_comptable'] >=5200 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 5299 )  ){

				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				$sous_categorie_plan_comptable['solde_restant']		=  $sous_categorie_plan_comptable['total_entree'] - $sous_categorie_plan_comptable['total_sortie'] ;
				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
				$disponible_banque_array [] = $sous_categorie_plan_comptable;
			}
		}
		$disponible_banque_array['total_entrees'] =  $total_entrees;
		$disponible_banque_array['total_sorties'] =  $total_sorties;
		$disponible_banque_array['solde'] =  $total_entrees - $total_sorties ;
		return $disponible_banque_array;
	}

	public function _build_disponible_caisse_array($sous_categorie_plan_comptables, $sql =null)
	{
		$disponible_caisse_array = [];
		$total_entrees = 0;
		$total_sorties = 0;
		 
		foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
			
			if( ( (int) $sous_categorie_plan_comptable['code_comptable'] >=5700 AND (int) $sous_categorie_plan_comptable['code_comptable'] <= 5799 )  ){

				$sous_categorie_plan_comptable['total_entree'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],1,$sql);
				$sous_categorie_plan_comptable['total_sortie'] 		=  (int) $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($sous_categorie_plan_comptable['id_sous_categorie_comptable'],2,$sql);
				$sous_categorie_plan_comptable['solde_restant']		=  $sous_categorie_plan_comptable['total_entree'] - $sous_categorie_plan_comptable['total_sortie'] ;
				$total_entrees 										=  (int) $total_entrees + (int) $sous_categorie_plan_comptable['total_entree'] ;
				$total_sorties 										=  (int) $total_sorties + (int) $sous_categorie_plan_comptable['total_sortie'] ;
				$disponible_caisse_array [] = $sous_categorie_plan_comptable;
			}
		}
		$disponible_caisse_array['total_entrees'] =  $total_entrees;
		$disponible_caisse_array['total_sorties'] =  $total_sorties;
		$disponible_caisse_array['solde'] =  $total_entrees - $total_sorties ;
		return $disponible_caisse_array;
	}

	public function _build_solde_caisse( $sql =null )
	{
		$solde_caisse_cdf_row 	= $this->Livre_caisse_banque_model->get_last_livre_caisse_banque_table_row_by_id_device_type_livre(1,1,$sql);
		$solde_caisse_usd_row 	= $this->Livre_caisse_banque_model->get_last_livre_caisse_banque_table_row_by_id_device_type_livre(2,1,$sql);
		$solde_caisse_eur_row 	= $this->Livre_caisse_banque_model->get_last_livre_caisse_banque_table_row_by_id_device_type_livre(3,1,$sql);
		$solde_caisse_cdf 		= 0;
		$solde_caisse_usd 		= 0;
		$solde_caisse_eur 		= 0;
		$solde_caisse			= 0;

		if(!empty($solde_caisse_cdf_row)){
			$solde_caisse_cdf = ( (int) $solde_caisse_cdf_row['solde_restant_caissse'] / $solde_caisse_cdf_row['taux']);
		}

		if(!empty($solde_caisse_usd_row)){
			$solde_caisse_usd =  (int) $solde_caisse_usd_row['solde_restant_caissse'] ;
		}

		if(!empty($solde_caisse_eur_row)){
			$solde_caisse_eur = ( (int) $solde_caisse_eur_row['solde_restant_caissse'] / $solde_caisse_eur_row['taux']);
		}

		$solde_caisse  = $solde_caisse_cdf + $solde_caisse_usd + $solde_caisse_eur; 

		return $solde_caisse;  
	}

	public function _build_solde_banque( $sql =null )
	{
		$solde_banque_cdf_row 	= $this->Livre_caisse_banque_model->get_last_livre_caisse_banque_table_row_by_id_device_type_livre(1,2,$sql);
		$solde_banque_usd_row 	= $this->Livre_caisse_banque_model->get_last_livre_caisse_banque_table_row_by_id_device_type_livre(2,2,$sql);
		$solde_banque_eur_row 	= $this->Livre_caisse_banque_model->get_last_livre_caisse_banque_table_row_by_id_device_type_livre(3,2,$sql);
		$solde_banque_cdf 		= 0;
		$solde_banque_usd 		= 0;
		$solde_banque_eur 		= 0;
		$solde_banque			= 0;

		if(!empty($solde_banque_cdf_row)){
			$solde_banque_cdf = ( (int) $solde_banque_cdf_row['solde_restant_caissse'] / $solde_banque_cdf_row['taux']);
		}
		if(!empty($solde_banque_usd_row)){
			$solde_banque_usd =  (int) $solde_banque_usd_row['solde_restant_caissse'] ;
		}
		if(!empty($solde_banque_eur_row)){
			$solde_banque_eur = ( (int) $solde_banque_eur_row['solde_restant_caissse'] / $solde_banque_eur_row['taux']);
		}

		$solde_banque  = $solde_banque_cdf + $solde_banque_usd + $solde_banque_eur; 

		return $solde_banque;  
	}


	public function format_array($array_code_comptable_in){


		$array_code_comptable_total_entree  = 0;
		$array_code_comptable_total_sortie  = 0;
		$array_code_comptable_solde_restant = 0;
		$array_code_comptable_in_final   = [];
		$designation = ''; 
		$last_code = '0000';
		
		foreach ($array_code_comptable_in as $key => $array_code_comptable) {
			$founded = 0;
			if($array_code_comptable['code_comptable'] <> $last_code){
				
				for ($i=$key; $i < count($array_code_comptable_in) ; $i++) { 
					if($array_code_comptable['code_comptable'] == $array_code_comptable_in[$i]['code_comptable']){
						$founded ++;
						$array_code_comptable_total_entree  = $array_code_comptable_total_entree  + $array_code_comptable_in[$i]['total_entree'];
						$array_code_comptable_total_sortie  = $array_code_comptable_total_sortie  + $array_code_comptable_in[$i]['total_sortie'];
						$array_code_comptable_solde_restant = $array_code_comptable_solde_restant + $array_code_comptable_in[$i]['solde_restant'];
						$designation.= $array_code_comptable_in[$i]['designation_sous_categorie_plan_comptable'].', ';
					}
				}

				if($founded < 2){
					$array_code_comptable_in_final[] = $array_code_comptable;
				}else{
					$array_code_comptable_in_buider = [
						'id_sous_categorie_comptable'=>0,
						'designation_sous_categorie_plan_comptable'=>$designation,
						'description_sous_categorie_comptable'=>'',
						'code_comptable'=>$array_code_comptable['code_comptable'],
						'id_foreign_entreprise_salesienne'=>0,
						'id_foreign_categorie_plan_comptable'=>0,
						'nom_entreprise_salesienne'=>$array_code_comptable['nom_entreprise_salesienne'],
						'total_entree'=>$array_code_comptable_total_entree,
						'total_sortie'=>$array_code_comptable_total_sortie,
						'solde_restant'=>$array_code_comptable_solde_restant,
					];
					$array_code_comptable_in_final[] = $array_code_comptable_in_buider;
					
				}

				$array_code_comptable_total_entree  = 0; 
				$array_code_comptable_total_sortie  = 0;
				$array_code_comptable_solde_restant = 0;
				$designation = '';
				$last_code = $array_code_comptable['code_comptable'];

			}
		}
		
		return $array_code_comptable_in_final;
	}

}
