<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Budget extends CI_Controller {

	public function index($id_year = null)
	{
		if(  $this->session->logged_in ){

			if(check_privilege('budget', $this->session->user['id_role'], 'voir')){
				
				$crud 						= new grocery_CRUD();
				$dashboard_link_active 		= "link_menu_active";
				$annee_excerice 			= (date('Y') -1);
				$entreprise_salesiennes 	= $this->Entreprise_salesienne_model->get_all_entreprise_salesiennes(); 
				$id_user_entreprise 		= (int) $_SESSION['user']['id_foreign_entreprise_salesienne']; 

				
				
				if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] <>0){
					$crud->where(['id_foreign_budget_entreprise_salesienne'=> (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] ]);
				}
				

				if( (isset( $_POST['annee_exercice'] ) AND $_POST['annee_exercice'] <> 'null') OR (isset($id_year) AND $id_year <> null AND  (int)$id_year > 2000) ){

					
					$annee_excerice	=  ( isset($_POST['annee_exercice']) ) ? $_POST['annee_exercice'] : $id_year;
					$sql 			=  "annee_exercice ='".$annee_excerice."'";
					
					if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] <> 'null'){
						if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne']  <> 0){
							$sql .=" AND id_foreign_budget_entreprise_salesienne = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
						}else{
							$sql .=" AND id_foreign_budget_entreprise_salesienne =".$_POST['id_entreprise_salesienne']."";
						}
						$id_user_entreprise 		= (int) $_POST['id_entreprise_salesienne']; 
					}else{
						$sql .=" AND id_foreign_budget_entreprise_salesienne = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
					}
					
					$crud->where($sql);
				}
				else{
						$crud->where(['id_foreign_budget_entreprise_salesienne'=> 0 ]);
				}

				$crud->set_table('budget_entreprise_salesienne');
				$crud->columns('id_budget_entreprise_salesienne','id_foreign_budget_entreprise_salesienne','id_foreign_sous_categorie_affectee_budget','Libellé','unite_1','id_foreign_type_unite_1','unite_2','id_foreign_type_unite_2','recette_cout_unitaire','recette_cout_total');
				$crud->display_as('id_budget_entreprise_salesienne','#');
				$crud->display_as('id_foreign_budget_entreprise_salesienne','Oeuvre de Don Bosco');
				$crud->display_as('id_foreign_sous_categorie_affectee_budget','Code Comptable');
				$crud->display_as('unite_1','Unités');
				$crud->display_as('id_foreign_type_unite_1','Type unité 1');
				$crud->display_as('unite_2','Unités');
				$crud->display_as('id_foreign_type_unite_2','Type unité 2');
				$crud->display_as('recette_cout_unitaire','Recette / cout unitaire $');
				$crud->display_as('recette_cout_total','Recette cout total $');
				$crud->set_subject('Une Entrée du Budget');
	
				$crud->callback_before_insert(array($this,'_onRowBeforeInsert'));
				$crud->callback_after_insert(array($this, '_onRowInserted'));
				$crud->callback_before_update(array($this, '_onRowBeforeUpdated'));
				$crud->callback_after_update(array($this, '_onRowUpdated'));
				$crud->callback_before_delete(array($this, '_onRowDeleted'));

				$crud->callback_column('id_foreign_budget_entreprise_salesienne',array($this,'_callback_entreprise_salesienne'));
				$crud->callback_column('Libellé',array($this,'_callback_libele_code_comptable'));
	
				$sous_categorie_affectee_budget_dropdown = $this->buildSousCategorieAffecteeDropDown( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] );
				$crud->field_type('id_foreign_sous_categorie_affectee_budget','dropdown',$sous_categorie_affectee_budget_dropdown);
				$crud->set_rules('recette_cout_unitaire','Recette cout unitaire','numeric');

				
				$crud->set_relation('id_foreign_type_unite_1','type_unite_one','designation_type_unite_one');
				$crud->set_relation('id_foreign_type_unite_2','type_unite_two','designation_type_unite_two');
				$crud->required_fields('id_budget_entreprise_salesienne','id_foreign_budget_entreprise_salesienne','id_foreign_sous_categorie_affectee_budget','unite_1','id_foreign_type_unite_1','unite_2','id_foreign_type_unite_2','recette_cout_unitaire');
				
				if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] <> 0){
					$crud->field_type('id_foreign_budget_entreprise_salesienne','hidden', $_SESSION['user']['id_foreign_entreprise_salesienne'] );
				}else{
					$crud->set_relation('id_foreign_budget_entreprise_salesienne','entreprise_salesienne','nom_entreprise_salesienne');
				}

				$crud->field_type('recette_cout_total','hidden');
				$crud->callback_add_field('annee_exercice',array($this,'_callback_add_annee_exercice'));
				$crud->unset_clone();
				$this->stateDisplay($crud);

				if( ! check_privilege('budget', $this->session->user['id_role'], 'ajouter') ){
					$crud->unset_add();
				}

				if( ! check_privilege('budget', $this->session->user['id_role'], 'editer') ){
					$crud->unset_edit();
				}

				if( ! check_privilege('budget', $this->session->user['id_role'], 'voir') ){
					$crud->unset_read();
				}

				if( ! check_privilege('budget', $this->session->user['id_role'], 'supprimer') ){
					$crud->unset_delete();
				}

				if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0){
					$crud->unset_add();
					$crud->unset_read();
					$crud->unset_edit();
					$crud->unset_delete();
				}

				$crud->order_by('id_budget_entreprise_salesienne','desc');
	
				$output = $crud->render();
	
				$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$navbar = $this->load->view("layouts/menu_nav_bar", ['dashboard_link_active'=>$dashboard_link_active], true);
				$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$this->load->view("budget/budget", ['header' => $header, 'navbar'=>$navbar, 'footer' => $footer,'output'=>$output->output,'entreprise_salesiennes'=>$entreprise_salesiennes,'annee_excerice'=>$annee_excerice,'id_user_entreprise'=>$id_user_entreprise]);	

			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}	
		}else {
			redirect("Starter/login");
		}
	}

	public function stateDisplay($crud){
		$state = $crud->getState();

		switch ($state) {
			case 'read':
				$crud->set_subject("Une Entrée du Budget ");
				break;
			case 'list':
				$crud->set_subject("Une Entrée du Budget ");
				break;
			case 'add':
				$crud->set_subject("D'Une Entrée du Budget ");
				break;
			
			case 'edit':
				$crud->set_subject("D'Une Entrée du Budget ");
				break;
			
			default:
				break;
		}

	}

	public function start()
	{
		if(  $this->session->logged_in ){
				$dashboard_link_active = "link_menu_active";
				$header 	= $this->load->view("layouts/header", [], true);
				$navbar 	= $this->load->view("layouts/menu_nav_bar", ['dashboard_link_active'=>$dashboard_link_active], true);
				$footer 	= $this->load->view("layouts/footer", [], true);
				$this->load->view("budget/index", ['header' => $header, 'navbar'=>$navbar, 'footer' => $footer]);
		}else{
			redirect("Starter/login");
		}
	}

	public function _showImage($value,$row)
	{
		return "<img src='".base_url('assets/uploads/files/'.$value)."' width='100px' height='100px' style='object-fit: content;'/>";
	}


	public function _onRowBeforeInsert($post_array)
	{
		$post_array['recette_cout_total'] = $post_array['unite_1'] * $post_array['unite_2'] * ceil($post_array['recette_cout_unitaire']);
		return $post_array;
	}

	public function _onRowBeforeUpdated($post_array,$primary_key)
	{
		$post_array['recette_cout_total'] = $post_array['unite_1'] * $post_array['unite_2'] * ceil($post_array['recette_cout_unitaire']);
		return $post_array;
	}

	public function _onRowInserted($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Budget Entreprise Salesienne',
			"id_champ"=> $primary_key,
			"action" => "insertion", 
			"text_descriptif" => "ajout d'Une Entrée du Budget ID : ".$primary_key,
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowUpdated($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Budget Entreprise Salesienne',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "mise à jourde d'une entrée du Budget ID : ".$primary_key,
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

    
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowDeleted($primary_key)
	{
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Budget Entreprise Salesienne',
			"id_champ"=> $primary_key,
			"action" => "Suppression",
			"text_descriptif" => "suppression d'une entrée du Budget ID : ".$primary_key,
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")		
		];
		$this->Action_utilisateur_model->add( $action );
		return true;
	}


	public function buildSousCategorieAffecteeDropDown($id_user_entreprise){

		$sous_categorie_affectee_result = [];
		$sous_categorie_affectees 		= $this->Sous_categorie_affectee_model->get_sous_categorie_comptable_affectee_by_id_entreprise($id_user_entreprise);
		
		if((int) $id_user_entreprise  ==  0){
			$sous_categorie_affectees = $this->Sous_categorie_affectee_model->get_all_sous_categorie_comptable_affectees();
		}

		$ids_sous_categorie_affectees 	= [];
		if(!empty( $sous_categorie_affectees) ){
			foreach ($sous_categorie_affectees as $key => $sous_categorie_affectee) {
				$ids_sous_categorie_affectees = explode(',',$sous_categorie_affectee['id_foreign_sous_categorie']);
				foreach ($ids_sous_categorie_affectees as $key => $id_sous_categorie_affectees) {
					$sous_categorie = $this->Sous_categorie_model->get_sous_categorie_comptable($id_sous_categorie_affectees);
					if(!empty($sous_categorie)){
						$sous_categorie_affectee_result[ $sous_categorie['id_sous_categorie_comptable'] ] =$sous_categorie['code_comptable']." - ".$sous_categorie['designation_sous_categorie_plan_comptable'];
						//$sous_categorie_affectee_result[ $sous_categorie['id_sous_categorie_comptable'] ] = $sous_categorie['code_comptable'];
					}
				}
			}
		}
		return $sous_categorie_affectee_result;
	}

	public function _callback_add_annee_exercice()
	{
		return '<input type="number" maxlength="50" value="'.((int)date('Y')-1).'" name="annee_exercice" class="numeric form-control">';
	}

	public function _callback_entreprise_salesienne($value, $row){
		$entreprise_salesienne = $this->Entreprise_salesienne_model->get_entreprise_salesienne($value);
		if(!empty($entreprise_salesienne)){
			return '<span> '.$entreprise_salesienne['nom_entreprise_salesienne']. ' <span>';
		}
	}

	public function _callback_libele_code_comptable($value, $row){
		$entree_budget 			  = $this->Budget_entreprise_salesienne_model->get_budget_entreprise_salesienne($row->id_budget_entreprise_salesienne);
		if(!empty($entree_budget)){
			$sous_categorie_comptable = $this->Sous_categorie_model->get_sous_categorie_comptable( (int) $entree_budget['id_foreign_sous_categorie_affectee_budget'] );
			if(!empty($sous_categorie_comptable) ){
				return '<span> '.$sous_categorie_comptable['designation_sous_categorie_plan_comptable']. ' <span>';
			}
		}
	}

	public function afficherBuget($annee_excerice =null, $id_user_entreprise=null)
	{
		if(  $this->session->logged_in ){

			$annee_excerice 						= (isset($_POST['annee_exercice'])) ? (int)$_POST['annee_exercice'] : (int) $annee_excerice;
			$id_user_entreprise 					= (isset($_POST['id_entreprise_salesienne'])) ? $_POST['id_entreprise_salesienne'] : (int) $id_user_entreprise;
			

			if($id_user_entreprise == "situation de la province"){
				$entreprise_salesiennne['nom_entreprise_salesienne'] = 'situation de la province';
				$entrees_budget_entreprise_salesienne	= $this->Budget_entreprise_salesienne_model->get_budget_entreprise_salesienne_by_annee($annee_excerice);
			
			}else{
				$entreprise_salesiennne 				= $this->Entreprise_salesienne_model->get_entreprise_salesienne($id_user_entreprise);			
				$entrees_budget_entreprise_salesienne	= $this->Budget_entreprise_salesienne_model->get_budget_entreprise_salesienne_by_id_entreprise_annee($id_user_entreprise,$annee_excerice);
			}

			$entreprise_salesiennes					= $this->Entreprise_salesienne_model->get_all_entreprise_salesiennes();
			$entrees_budget_entreprise_salesienne 	= $this->_refactor_budget_entreprise_array($entrees_budget_entreprise_salesienne);
			$budget_entreprise 						= $this->_build_budget_entreprise_array($entrees_budget_entreprise_salesienne,$annee_excerice);
			
			$_POST['id_entreprise_salesienne'] 		= ( isset($_POST['id_entreprise_salesienne']) ) ? $_POST['id_entreprise_salesienne'] : $id_user_entreprise;
			$_POST['annee_exercice'] 				= ( isset($_POST['annee_exercice']) ) ? $_POST['annee_exercice'] : $annee_excerice;
			
			$crud 	= new grocery_CRUD();
			$crud->set_table('sexe');
			$output = $crud->render();
			
			$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
			$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
			$this->load->view("budget/afficher_budget", [
				'header'=>$header,
				'footer'=>$footer,
				'output'=>$output->output,
				'annee_excerice'=>$annee_excerice,
				'id_user_entreprise'=>$id_user_entreprise,
				'entreprise_salesiennne'=>$entreprise_salesiennne,
				'budget_entreprise'=>$budget_entreprise,
				'entreprise_salesiennes'=>$entreprise_salesiennes,
			]);	
			
		}
		else {
			redirect("Starter/login");
		}
	}

	public function _refactor_budget_entreprise_array($entrees_budget_entreprise_salesienne)
	{
		foreach ($entrees_budget_entreprise_salesienne as $key => $entree_budget_entreprise_salesienne) {
			$foreign_type_unite_1 = $this->Type_unite_one_model->get_type_unite_one($entree_budget_entreprise_salesienne['id_foreign_type_unite_1']);
			$foreign_type_unite_2 = $this->Type_unite_two_model->get_type_unite_two($entree_budget_entreprise_salesienne['id_foreign_type_unite_2']);
			$entree_budget_entreprise_salesienne['id_foreign_type_unite_1'] = (!empty( $foreign_type_unite_1)) ? $foreign_type_unite_1['designation_type_unite_one'] : $entree_budget_entreprise_salesienne['id_foreign_type_unite_1'];
			$entree_budget_entreprise_salesienne['id_foreign_type_unite_2'] = (!empty( $foreign_type_unite_2)) ? $foreign_type_unite_2['designation_type_unite_two'] : $entree_budget_entreprise_salesienne['id_foreign_type_unite_2'];
			$entrees_budget_entreprise_salesienne[$key] = $entree_budget_entreprise_salesienne;
		}

		return $entrees_budget_entreprise_salesienne;
	}

	public function _build_budget_entreprise_array($entrees_budget_entreprise_salesienne,$annee_excerice ='')
	{
		
		$categorie_comptables					= [];
		if(!empty( $entrees_budget_entreprise_salesienne) ){
			foreach ($entrees_budget_entreprise_salesienne as $key => $entree_budget_entreprise_salesienne) {
				$sous_categorie = $this->Sous_categorie_model->get_sous_categorie_comptable($entree_budget_entreprise_salesienne['id_foreign_sous_categorie_affectee_budget']);
				$entreprise_salesiennne = $this->Entreprise_salesienne_model->get_entreprise_salesienne($entree_budget_entreprise_salesienne['id_foreign_budget_entreprise_salesienne']);			
				if(!empty($sous_categorie)){
					$categorie_comptable = $this->Categorie_plan_comptable_model->get_categorie_plan_comptable( $sous_categorie['id_foreign_categorie_plan_comptable'] );
					$entree_budget_entreprise_salesienne['id_foreign_sous_categorie_affectee_budget'] 	= $sous_categorie['designation_sous_categorie_plan_comptable']. ' <b>('.$entreprise_salesiennne['nom_entreprise_salesienne'].')</b>' ;				
					$entree_budget_entreprise_salesienne['code_comptable'] 								= $sous_categorie['code_comptable'];	
					$entree_budget_entreprise_salesienne['recette_cout_realiser'] 						= $this->Livre_caisse_banque_model->get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_annee_exrcice($entree_budget_entreprise_salesienne['id_foreign_budget_entreprise_salesienne'], $sous_categorie['id_sous_categorie_comptable'],$annee_excerice);
					$entree_budget_entreprise_salesienne['reste_a_realiser']							= $entree_budget_entreprise_salesienne['recette_cout_total'] -  $entree_budget_entreprise_salesienne['recette_cout_realiser'];	
					$entree_budget_entreprise_salesienne['taux_execution'] 								= ($entree_budget_entreprise_salesienne['recette_cout_realiser'] / $entree_budget_entreprise_salesienne['recette_cout_total'] ) * 100;
					$entree_budget_entreprise_salesienne['taux_realiser'] 								= ($entree_budget_entreprise_salesienne['reste_a_realiser'] / $entree_budget_entreprise_salesienne['recette_cout_total'] ) * 100;


					if(!empty($categorie_comptable)){
						if( (int) $categorie_comptable['id_foreign_type_categorie_plan_comptable'] == 1){
							if( isset( $categorie_comptables['RECETTES'][$categorie_comptable['id_categorie_plan_comptable'] ] ) ){
								$categorie_comptables['RECETTES'][$categorie_comptable['id_categorie_plan_comptable'] ]['BUDGET'][] = $entree_budget_entreprise_salesienne;
							}else{
								$categorie_comptables['RECETTES'][$categorie_comptable['id_categorie_plan_comptable'] ] = $categorie_comptable;
								$categorie_comptables['RECETTES'][$categorie_comptable['id_categorie_plan_comptable'] ]['BUDGET'][] = $entree_budget_entreprise_salesienne;
							}
						}else{
							if( isset( $categorie_comptables['DEPENSES'][$categorie_comptable['id_categorie_plan_comptable'] ] ) ){
								$categorie_comptables['DEPENSES'][$categorie_comptable['id_categorie_plan_comptable'] ]['BUDGET'][] = $entree_budget_entreprise_salesienne;
							}else{
								$categorie_comptables['DEPENSES'][$categorie_comptable['id_categorie_plan_comptable'] ] = $categorie_comptable;
								$categorie_comptables['DEPENSES'][$categorie_comptable['id_categorie_plan_comptable'] ]['BUDGET'][] = $entree_budget_entreprise_salesienne;
							}
						}
					}
				}
			}
		}
		return $categorie_comptables;
	}
	
}
