<?php
header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT");
defined('BASEPATH') OR exit('No direct script access allowed');

class Caisse extends CI_Controller {

	public function index($id_caisse = null)
	{
		if(  $this->session->logged_in ){
			if(check_privilege('caisse', $this->session->user['id_role'], 'voir')){


				$crud = new grocery_CRUD();
				$caisses 					= $this->Caisse_model->get_all_caisses(); 
				$entreprise_salesiennes 	= $this->Entreprise_salesienne_model->get_all_entreprise_salesiennes(); 
				$types_de_caisses 			= $this->Type_caisse_model->get_all_type_caisses();
				$montant_caisse_cdf 		= 0;
				$montant_caisse_usd 		= 0;
				$settings_link_active = 'link_menu_active';



				if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne']  <> 0){
					$crud->where(['id_foreign_entreprise_salesienne'=> $_SESSION['user']['id_foreign_entreprise_salesienne'] ]);
					$caisses = $this->Caisse_model->get_caisse_by_id_entreprise((int)$_SESSION['user']['id_foreign_entreprise_salesienne']);
				}

				if($id_caisse <> null AND is_int( (int) $id_caisse) AND $id_caisse<> 'edit' AND $id_caisse<>'success' AND $id_caisse<>'read'){
					$id_caisse 	= (int) $id_caisse;
					$crud->where(['id_caisse'=>$id_caisse]);
					$caisses 	= [];
					$caisses[0] = $this->Caisse_model->get_caisse_by_id($id_caisse); 
				}


				if( isset( $_POST['start_date'] )  AND isset($_POST['end_date'])){

					$sql =" date_enregistrement_caisse_salesienne BETWEEN '".$_POST['start_date']."' AND '".$_POST['end_date']."'";
					
					if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] <> 'null'){
						$sql .=" AND id_foreign_entreprise_salesienne =".$_POST['id_entreprise_salesienne']."";
					}else{
						$sql .=" AND id_foreign_entreprise_salesienne = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
					}

					if(  isset( $_POST['id_foreign_type_caisse'] ) AND $_POST['id_foreign_type_caisse'] <> 'null'){
						$sql .=" AND id_foreign_type_caisse =".$_POST['id_foreign_type_caisse']."";
					}


					$crud->where($sql);

					$caisses 	= $this->Caisse_model->get_caisses_by_query('SELECT * FROM caisse WHERE '.$sql);
				}

				$crud->set_table('caisse');
				$crud->columns('id_caisse','nom_caisse','montant_caisse','id_devise','id_foreign_entreprise_salesienne','id_foreign_type_caisse','numero_caisse','date_enregistrement_caisse_salesienne','is_caisse_active');
				$crud->display_as('id_caisse','#');
				$crud->display_as('nom_caisse','Nom');
				$crud->display_as('montant_caisse','Montant');
				$crud->display_as('id_devise','Devise ');
				$crud->display_as('id_foreign_entreprise_salesienne','Oeuvre de Don Bosco ');
				$crud->display_as('id_foreign_type_caisse','Type ');
				$crud->display_as('numero_caisse','Numéro Caisse ');
				$crud->display_as('is_caisse_active','Etat');
				$crud->display_as('date_enregistrement_caisse_salesienne','Date d\'enregistrement ');
				$crud->set_subject('Une caisse');
	
				$crud->callback_before_insert(array($this, '_onRowBeforeInserted'));
				$crud->callback_after_insert(array($this, '_onRowInserted'));
				$crud->callback_before_update(array($this, '_onRowBeforeUpdated'));
				$crud->callback_after_update(array($this, '_onRowUpdated'));
				$crud->callback_before_delete(array($this, '_onRowDeleted'));
	
				$crud->set_relation('id_foreign_type_caisse','type_caisse','designation');
				$crud->set_relation('id_devise','device_caisse','abreviation');
				$crud->set_relation('is_caisse_active','is_active','designation');

				$crud->required_fields('nom_caisse','id_devise','id_foreign_entreprise_salesienne','id_foreign_type_caisse','numero_caisse','is_caisse_active');
				$crud->unset_clone();
				$crud->callback_column('id_foreign_entreprise_salesienne',array($this,'_callback_entreprise_salesienne'));
				$crud->field_type('date_enregistrement_caisse_salesienne', 'hidden',date('Y-m-d'));

				if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne']  <> 0){
					$crud->field_type('id_foreign_entreprise_salesienne', 'hidden', $_SESSION['user']['id_foreign_entreprise_salesienne'] );
				}else{
					$crud->set_relation('id_foreign_entreprise_salesienne','entreprise_salesienne','nom_entreprise_salesienne');
				}

				$this->stateDisplay($crud);


				$montant_caisse_cdf = $this->calculateSommeUsdCdfEur($caisses, 1);
				$montant_caisse_usd = $this->calculateSommeUsdCdfEur($caisses, 2);
				$montant_caisse_eur = $this->calculateSommeUsdCdfEur($caisses, 3);

				if( ! check_privilege('caisse', $this->session->user['id_role'], 'ajouter') ){
					$crud->unset_add();
				}

				if( ! check_privilege('caisse', $this->session->user['id_role'], 'editer') ){
					$crud->unset_edit();
				}

				if( ! check_privilege('caisse', $this->session->user['id_role'], 'voir') ){
					$crud->unset_read();
				}

				if( ! check_privilege('caisse', $this->session->user['id_role'], 'supprimer') ){
					$crud->unset_delete();
				}

				if( $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0){
					$crud->unset_add();
					$crud->unset_edit();
					$crud->unset_delete();				
				}

				$crud->order_by('id_caisse','desc');
	
				$output = $crud->render();

				$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$sidebar = $this->load->view("layouts/sidebar", [], true);
				$navbar = $this->load->view("layouts/menu_nav_bar", ['settings_link_active'=>$settings_link_active], true);				$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$this->load->view("caisse/caisse", ['header' => $header, 'navbar'=>$navbar, 'sidebar' => $sidebar, 'footer' => $footer,'output'=>$output->output,'entreprise_salesiennes'=>$entreprise_salesiennes,'types_de_caisses'=>$types_de_caisses,'montant_caisse_cdf'=>$montant_caisse_cdf,'montant_caisse_usd'=>$montant_caisse_usd,'caisses'=>$caisses,'montant_caisse_eur'=>$montant_caisse_eur]);	

			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}	
		}else {
			redirect("Starter/login");
		}
	}

	public function stateDisplay($crud){
		$state = $crud->getState();

		switch ($state) {
			case 'read':
				$crud->set_subject("Une caisse ");
				break;
			case 'list':
				$crud->set_subject("Une caisse ");
				break;
			case 'add':
				$crud->set_subject("D'Une caisse ");
				break;
			
			case 'edit':
				$crud->set_subject("D'Une caisse ");
				break;
			
			default:
				break;
		}

	}

	public function _showImage($value,$row)
	{
		return "<img src='".base_url('assets/uploads/files/'.$value)."' width='100px' height='100px' style='object-fit: content;'/>";
	}

	public function _onRowBeforeInserted($post_array){
		// if( (int) $post_array['is_caisse_active'] == 1){
		// 	$update_caisse_state =[
		// 		'is_caisse_active' =>2
		// 	];
		// 	$this->Caisse_model->update_by_state_devise_type(1,$post_array['id_devise'],$post_array['id_foreign_type_caisse'],$update_caisse_state);
		// }
	}

	public function _onRowBeforeUpdated( $post_array, $primary_key ){
		// if( (int) $post_array['is_caisse_active'] == 1){
		// 	$update_caisse_state =[
		// 		'is_caisse_active' =>2
		// 	];
		// 	$this->Caisse_model->update_by_state_devise_type(1,$post_array['id_devise'],$post_array['id_foreign_type_caisse'],$update_caisse_state);
		// }
	}

	public function _onRowInserted($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Une caisse',
			"id_champ"=> $primary_key,
			"action" => "insertion", 
			"text_descriptif" => "ajout d'une caisse ".$post_array["nom_caisse"],
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowUpdated($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Une caisse',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "mise à jour de la caisse ".$post_array["nom_caisse"],
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

    
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowDeleted($primary_key)
	{
		$data = ['id_caisse'=>$primary_key];
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Une caisse',
			"id_champ"=> $primary_key,
			"action" => "Suppression",
			"text_descriptif" => "suppression de la caisse ".$this->ModelGetTableRow->getObjectFieldValue($data,'caisse')->nom_caisse,
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")		
		];
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	function calculateSommeUsdCdfEur($caisses,$usd_cdf_eur){
		$montant_usd_cdf_eur = 0;
		foreach ($caisses as $key => $caisse) {
			if(isset($caisse)){
				if( (int)$caisse['id_devise'] == (int) $usd_cdf_eur){
					$montant_usd_cdf_eur = $montant_usd_cdf_eur + $caisse['montant_caisse'];
				}
			}
		}
		return $montant_usd_cdf_eur;
	}

	public function _callback_entreprise_salesienne($value, $row){
		$entreprise_salesienne = $this->Entreprise_salesienne_model->get_entreprise_salesienne($value);
		if(!empty($entreprise_salesienne)){
			return $entreprise_salesienne['nom_entreprise_salesienne'];
		}
	}
	
}
