<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Categorie_comptable extends CI_Controller {

	public function index()
	{
		if(  $this->session->logged_in ){
			if(check_privilege('categorie_plan_comptable', $this->session->user['id_role'], 'voir')){
				
				$crud = new grocery_CRUD();
				$settings_link_active = 'link_menu_active';

				if( $_SESSION['user']['id_foreign_entreprise_salesienne'] <> 0){
					$crud->where(['id_foreign_entreprise_salesienne_categorie_plan_comptable'=>$_SESSION['user']['id_foreign_entreprise_salesienne']]);
				}

				$crud->set_table('categorie_plan_comptable');
				$crud->columns('id_categorie_plan_comptable','designation_categorie_plan_comptable','description','id_foreign_entreprise_salesienne_categorie_plan_comptable','id_foreign_type_categorie_plan_comptable');
				$crud->display_as('id_categorie_plan_comptable','#');
				$crud->display_as('designation_categorie_plan_comptable','Designation');
				$crud->display_as('description','Descritpion');
				$crud->display_as('id_foreign_entreprise_salesienne_categorie_plan_comptable','Oeuvre de Don Bosco');
				$crud->display_as('id_foreign_type_categorie_plan_comptable','Type');
				$crud->display_as('fichier_excel_upload','Fichier Excel');
				$crud->set_subject('Une Categorie Comptable');
	
				$crud->callback_after_insert(array($this, '_onRowInserted'));
				$crud->callback_after_update(array($this, '_onRowUpdated'));
				$crud->callback_before_delete(array($this, '_onRowDeleted'));

				if( $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0){
					$crud->set_relation('id_foreign_entreprise_salesienne_categorie_plan_comptable','entreprise_salesienne', 'nom_entreprise_salesienne' );
				}else{
					$crud->field_type('id_foreign_entreprise_salesienne_categorie_plan_comptable','hidden', $_SESSION['user']['id_foreign_entreprise_salesienne'] );
				}
	
				
				$crud->set_relation('id_foreign_type_categorie_plan_comptable','type_categorie_plan_comptable','designation');
				$crud->required_fields('designation_categorie_plan_comptable','id_foreign_type_categorie_plan_comptable');
				$crud->unset_clone();				
				$crud->callback_column('id_foreign_entreprise_salesienne_categorie_plan_comptable',array($this,'_callback_entreprise_salesienne'));
				$this->stateDisplay($crud);

				if( ! check_privilege('categorie_plan_comptable', $this->session->user['id_role'], 'ajouter') ){
					$crud->unset_add();
				}

				if( ! check_privilege('categorie_plan_comptable', $this->session->user['id_role'], 'editer') ){
					$crud->unset_edit();
				}

				if( ! check_privilege('categorie_plan_comptable', $this->session->user['id_role'], 'voir') ){
					$crud->unset_read();
				}

				if( ! check_privilege('categorie_plan_comptable', $this->session->user['id_role'], 'supprimer') ){
					$crud->unset_delete();
				}

				if( $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0){
					// $crud->unset_add();
					// $crud->unset_edit();
					// $crud->unset_delete();
				}

				$crud->order_by('id_categorie_plan_comptable','desc');
	
				$output = $crud->render();
	
				$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$sidebar = $this->load->view("layouts/sidebar", [], true);
				$navbar = $this->load->view("layouts/menu_nav_bar", ['settings_link_active'=>$settings_link_active], true);
				$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$this->load->view("categorie_plan_comptable/categorie_plan_comptable", ['header' => $header, 'navbar'=>$navbar, 'sidebar' => $sidebar, 'footer' => $footer,'output'=>$output->output]);	

			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}	
		}else {
			redirect("Starter/login");
		}
	}

	public function stateDisplay($crud){
		$state = $crud->getState();

		switch ($state) {
			case 'read':
				$crud->set_subject("Une Categorie Comptable ");
				break;
			case 'list':
				$crud->set_subject("Une Categorie Comptable ");
				break;
			case 'add':
				$crud->set_subject("D'Une Categorie Comptable ");
				break;
			
			case 'edit':
				$crud->set_subject("D'Une Categorie Comptable ");
				break;
			
			default:
				break;
		}

	}


	function upload()
	{
		$settings_link_active = 'link_menu_active';
		$header = $this->load->view("layouts/header", [], true);
		$sidebar = $this->load->view("layouts/sidebar", [], true);
		$navbar = $this->load->view("layouts/menu_nav_bar", ['settings_link_active'=>$settings_link_active], true);
		$footer = $this->load->view("layouts/footer", [], true);
		$this->load->view("categorie_plan_comptable_upload/categorie_plan_comptable_upload", ['header' => $header, 'navbar'=>$navbar, 'sidebar' => $sidebar, 'footer' => $footer]);	
	}

	public function _showImage($value,$row)
	{
		return "<img src='".base_url('assets/uploads/files/'.$value)."' width='100px' height='100px' style='object-fit: content;'/>";
	}

	
	public function _onRowInserted($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Categorie Plan Comptable',
			"id_champ"=> $primary_key,
			"action" => "insertion", 
			"text_descriptif" => "ajout d'Une Categorie Comptable ".$post_array["designation_categorie_plan_comptable"],
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowUpdated($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Categorie Plan Comptable',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "mise à jourde de la Categorie Plan Comptable ".$post_array["designation_categorie_plan_comptable"],
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

    
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowDeleted($primary_key)
	{
		$data = ['id_categorie_plan_comptable'=>$primary_key];
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Categorie Plan Comptable',
			"id_champ"=> $primary_key,
			"action" => "Suppression",
			"text_descriptif" => "suppression de la Categorie Plan Comptable ".$this->ModelGetTableRow->getObjectFieldValue($data,'categorie_plan_comptable')->designation_categorie_plan_comptable,
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")		
		];
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _callback_entreprise_salesienne($value, $row){
		$entreprise_salesienne = $this->Entreprise_salesienne_model->get_entreprise_salesienne($value);
		if(!empty($entreprise_salesienne)){
			return '<span> '.$entreprise_salesienne['nom_entreprise_salesienne']. ' <span>';
		}
	}

	function fichier_excel_callback() {
		if(isset( $_FILES['fichier_excel']['tmp_name']) ){

			if( $_FILES['fichier_excel']['error'] == 0){

				// Dear developper fix this on the server side put the correct path
				$final_path 	= $_SERVER['DOCUMENT_ROOT'].'/salesien/assets/uploads/files/categorie_comptable.xlsx';

				if( move_uploaded_file($_FILES['fichier_excel']['tmp_name'], $final_path) ){

					$excel_reader   = SimpleXLSX::parse($final_path);
					$id_type_categorie_plan_comptable = 0;
					$x = 0;

					while($x <= count($excel_reader->rows()) ) {
						$cell1 = isset($excel_reader->rows()[$x][0]) ? $excel_reader->rows()[$x][0] : '';
						$cell2 = isset($excel_reader->rows()[$x][1]) ? $excel_reader->rows()[$x][1] : '';
						$cell3 = isset($excel_reader->rows()[$x][2]) ? $excel_reader->rows()[$x][2] : '';

						if(trim($cell1) == "BIGCAT"){
								$id_type_categorie_plan_comptable = ( trim($cell2) =='RECETTE (7000-7700)') ? 1 : 2;
						}
						if(trim($cell1) == "CAT"){
							$categorie_plan_comptable = $this->Categorie_plan_comptable_model->get_categorie_plan_comptable_by_designation($cell2);		
							if(empty($categorie_plan_comptable) OR count($categorie_plan_comptable) <= 1){
								$insert_categorie_plan_comptable = [
									'designation_categorie_plan_comptable'=>$cell2,
									'description'=>$cell3,
									'id_foreign_entreprise_salesienne_categorie_plan_comptable'=>$_SESSION['user']['id_foreign_entreprise_salesienne'],
									'id_foreign_type_categorie_plan_comptable'=>$id_type_categorie_plan_comptable,
								];
								$id_insert_categorie_plan_comptable = $this->Categorie_plan_comptable_model->add($insert_categorie_plan_comptable);
		
								$action = [
									"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
									"nom_table"=> 'Categorie Plan Comptable',
									"id_champ"=> $id_insert_categorie_plan_comptable,
									"action" => "insertion", 
									"text_descriptif" => "ajout par fichier excel d'Une Categorie Comptable ".$cell2,
									'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
									"date_heure" => date("Y-m-d H:m:i")
								];
						
								$this->Action_utilisateur_model->add( $action );
							}else{
								//echo 'alredy in ===><br>';
							}
								
						} 
						$x++;
					}
				}
			}

		}
		
		$this->index();
	}
	
}
