<?php

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT");
defined('BASEPATH') OR exit('No direct script access allowed');

class Depense_caisse extends CI_Controller {

	public function index()
	{
		if(  $this->session->logged_in ){
			if(check_privilege('depense_caisse', $this->session->user['id_role'], 'voir')){

				$crud 						= new grocery_CRUD();
				$depenses_caisses 			= $this->Depense_caisse_model->get_all_depense_caisses(); 
				$entreprise_salesiennes 	= $this->Entreprise_salesienne_model->get_all_entreprise_salesiennes(); 
				$types_de_caisses 			= $this->Type_caisse_model->get_all_type_caisses();
				$type_categorie_accounting	= $this->buildForeignSousCategorieDropDown( (int) $_SESSION['user']['id_foreign_entreprise_salesienne'] );
				$montant_caisse_cdf 		= 0;
				$montant_caisse_usd 		= 0;
				$id_type_caisse 			= null;

				if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne']  <> 0){
					$crud->where(['id_foreign_entreprise_salesienne_depense_caisse'=> $_SESSION['user']['id_foreign_entreprise_salesienne']]);
					$depenses_caisses 	= $this->Depense_caisse_model->get_depense_caisse_by_id_entreprise( $_SESSION['user']['id_foreign_entreprise_salesienne']);
				}

				if( isset( $_POST['start_date'] )  AND isset($_POST['end_date'])){

					$sql =" date_enregistrement_depense_caisse BETWEEN '".$_POST['start_date']."' AND '".$_POST['end_date']."'";
					
					if(  isset( $_POST['id_entreprise_salesienne'] ) AND $_POST['id_entreprise_salesienne'] <> 'null'){
						$sql .=" AND id_foreign_entreprise_salesienne_depense_caisse =".$_POST['id_entreprise_salesienne']."";
					}

					if(  isset( $_POST['id_foreign_type_categorie_comptable'] ) AND $_POST['id_foreign_type_categorie_comptable'] <> 'null'){
						$sql .=" AND id_foreign_categorie_accounting =".$_POST['id_foreign_type_categorie_comptable']."";
					}

					if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne']  <> 0){
						$sql .=" AND id_foreign_entreprise_salesienne_depense_caisse = ".$_SESSION['user']['id_foreign_entreprise_salesienne']."";
					}

					if( isset( $_POST['id_foreign_type_caisse'] ) AND $_POST['id_foreign_type_caisse'] <> 'null' ){
						$id_type_caisse = $_POST['id_foreign_type_caisse'];
					}
					
					$crud->where($sql);

					$depenses_caisses 	= $this->Depense_caisse_model->get_depense_caisses_by_query('SELECT * FROM depense_caisse WHERE '.$sql);
				}

				$crud->set_table('depense_caisse');
				$crud->columns('id_depense_caisse','montant_depense','id_foreign_categorie_accounting','description_depense_caisse','file_preuve','id_foreign_entreprise_salesienne_depense_caisse','id_foreign_entree_caisse','date_enregistrement_depense_caisse');
				$crud->display_as('id_depense_caisse','#');
				$crud->display_as('montant_depense','Montant');
				$crud->display_as('id_foreign_categorie_accounting','Catégorie Comptabble ');
				$crud->display_as('description_depense_caisse','Descritpion');
				$crud->display_as('file_preuve','Fichier de Preuve');
				$crud->display_as('id_foreign_entreprise_salesienne_depense_caisse','Entreprise Salesienne');
				$crud->display_as('id_foreign_entree_caisse','Caisse ');
				$crud->display_as('date_enregistrement_depense_caisse','Date d\'enregistrement ');
				$crud->set_subject('Une Dépense de caisse');
	
				$crud->callback_after_insert(array($this, '_onRowInserted'));
				$crud->callback_after_update(array($this, '_onRowUpdated'));
				$crud->callback_before_delete(array($this, '_onRowDeleted'));

				$montant_caisse_cdf = $this->calculateSommeUsdCdf($depenses_caisses, 1,$id_type_caisse);
				$montant_caisse_usd = $this->calculateSommeUsdCdf($depenses_caisses, 2,$id_type_caisse);
	
				$entrees_caisses_dropdown = $this->builEntreeCaisseDropDown( $_SESSION['user']['id_foreign_entreprise_salesienne'] );
			
				$crud->required_fields('montant_depense','id_foreign_categorie_accounting','id_foreign_entreprise_salesienne','id_foreign_entree_caisse','file_preuve');
				$crud->field_type('date_enregistrement_depense_caisse', 'hidden',date('Y-m-d'));
				$crud->field_type('id_foreign_categorie_accounting','dropdown',$type_categorie_accounting);
				$crud->field_type('id_foreign_entree_caisse','dropdown',$entrees_caisses_dropdown);
				$crud->set_field_upload('file_preuve','assets/uploads/files');

				$crud->unset_clone();
				$crud->unset_edit();

				if( (int) $_SESSION['user']['id_foreign_entreprise_salesienne']  <> 0){
					$crud->field_type('id_foreign_entreprise_salesienne_depense_caisse', 'hidden', $_SESSION['user']['id_foreign_entreprise_salesienne'] );
				}else{
					$crud->set_relation('id_foreign_entreprise_salesienne_depense_caisse','entreprise_salesienne','nom_entreprise_salesienne');
				}

				$this->stateDisplay($crud);

				if( ! check_privilege('depense_caisse', $this->session->user['id_role'], 'ajouter') ){
					$crud->unset_add();
				}

				if( ! check_privilege('depense_caisse', $this->session->user['id_role'], 'voir') ){
					$crud->unset_read();
				}

				if( ! check_privilege('depense_caisse', $this->session->user['id_role'], 'supprimer') ){
					$crud->unset_delete();
				}

				$crud->order_by('id_depense_caisse','desc');
	
				$output = $crud->render();
	
				$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$sidebar = $this->load->view("layouts/sidebar", [], true);
				$navbar = $this->load->view("layouts/navbar", [], true);
				$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$this->load->view("depense_caisse/depense_caisse", ['header' => $header, 'navbar'=>$navbar, 'sidebar' => $sidebar, 'footer' => $footer,'output'=>$output->output,'depenses_caisses'=>$depenses_caisses,'entreprise_salesiennes'=>$entreprise_salesiennes,'montant_caisse_cdf'=>$montant_caisse_cdf,'montant_caisse_usd'=>$montant_caisse_usd,'types_de_caisses'=>$types_de_caisses,'type_categorie_accounting'=>$type_categorie_accounting]);	
			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}	
		}else {
			redirect("Starter/login");
		}
	}

	public function stateDisplay($crud){
		$state = $crud->getState();

		switch ($state) {
			case 'read':
				$crud->set_subject("Une dépense de caisse ");
				break;
			case 'list':
				$crud->set_subject("Une dépense de caisse ");
				break;
			case 'add':
				$crud->set_subject("D'Une dépense de caisse ");
				break;
			
			case 'edit':
				$crud->set_subject("D'Une dépense de caisse ");
				break;
			
			default:
				break;
		}

	}

	public function _showImage($value,$row)
	{
		return "<img src='".base_url('assets/uploads/files/'.$value)."' width='100px' height='100px' style='object-fit: content;'/>";
	}

	public function _onRowInserted($post_array, $primary_key)
	{
		$entree_caisse 	=  $this->Entree_caisse_model->get_entree_caisse($post_array['id_foreign_entree_caisse']);
		
		if(!empty($entree_caisse)){
			$caisse 	=  $this->Caisse_model->get_caisse_by_id($entree_caisse['id_foreign_caisse']);
			if(!empty($caisse)){
				$caisse_montant = [
					'montant_caisse'=>(int)$caisse['montant_caisse'] - (int) $post_array['montant_depense']
				];
				$this->Caisse_model->update($caisse['id_caisse'], $caisse_montant);
			}
		}	
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'depense_caisse',
			"id_champ"=> $primary_key,
			"action" => "insertion", 
			"text_descriptif" => "ajout d'une dépense de caisse id = ".$post_array["id_depense_caisse"],
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowUpdated($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'depense_caisse',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "mise à jour d'une dépense de caisse id =  ".$post_array["id_depense_caisse"],
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

    
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowDeleted($primary_key)
	{
		$data = ['id_depense_caisse'=>$primary_key];
		$depense_caisse_object = $this->ModelGetTableRow->getObjectFieldValue($data,'depense_caisse');
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'depense_caisse',
			"id_champ"=> $primary_key,
			"action" => "Suppression",
			"text_descriptif" => "suppression de la dépense de caisse id =  ".$depense_caisse_object->id_depense_caisse,
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")		
		];
		$this->Action_utilisateur_model->add( $action );

		$entree_caisse 	=  $this->Entree_caisse_model->get_entree_caisse($depense_caisse_object->id_foreign_entree_caisse);
		
		if(!empty($entree_caisse)){
			$caisse 	=  $this->Caisse_model->get_caisse_by_id($entree_caisse['id_foreign_caisse']);
			if(!empty($caisse)){
				$caisse_montant = [
					'montant_caisse'=>(int)$caisse['montant_caisse'] + (int) $depense_caisse_object->montant_depense
				];
				$this->Caisse_model->update($caisse['id_caisse'], $caisse_montant);
			}
		}
		return true;
	}

	public function builEntreeCaisseDropDown($id_user_entreprise){
		$entrees_caisses_result = [];
		if((int) $id_user_entreprise <> 0){
			$entrees_caisses = $this->Entree_caisse_model->get_entree_caisse_by_id_entreprise($id_user_entreprise);
		}else{
			$entrees_caisses = $this->Entree_caisse_model->get_all_entree_caisses();
		}

		foreach ($entrees_caisses as $key => $entree_caisse) {
			$caisse = $this->Caisse_model->get_caisse_by_id($entree_caisse['id_foreign_caisse']);
			if(!empty($caisse)){
				$devise  = $this->Device_caisse_model->get_devise($caisse['id_devise']);
				if(!empty($devise)){
					$entrees_caisses_result[ $entree_caisse['id_entree_caisse'] ] = $caisse['nom_caisse']." Montant: ".$entree_caisse['montant_caisse']." ".$devise['abreviation']." ".$entree_caisse['description_entree_caisse'];
				}
			}
		}
		return $entrees_caisses_result;
	}

	function calculateSommeUsdCdf($depense_caisses,$usd_cdf, $id_type_caisse = null){
		$montant_usd_cdf = 0;
		foreach ($depense_caisses as $key => $depense_caisse) {
			$entree_caisse = $this->Entree_caisse_model->get_entree_caisse($depense_caisse['id_foreign_entree_caisse']);
			if(!empty($entree_caisse)){
				$foreign_caisse = $this->Caisse_model->get_caisse_by_id_cdf_usd($entree_caisse['id_foreign_caisse'],$usd_cdf);
				if(!empty( $foreign_caisse ) AND count($foreign_caisse) > 1){
					$montant_usd_cdf = $montant_usd_cdf + $depense_caisse['montant_depense'];
				}
			}
		}
		return $montant_usd_cdf;
	}

	public function buildForeignSousCategorieDropDown($id_user_entreprise){

		$sous_categorie_affectee_result = [];
		$sous_categorie_affectees 		= $this->Sous_categorie_affectee_model->get_sous_categorie_comptable_affectee_by_id_entreprise($id_user_entreprise);
		$ids_sous_categorie_affectees 	= [];
		if(!empty( $sous_categorie_affectees) ){
			foreach ($sous_categorie_affectees as $key => $sous_categorie_affectee) {
				$ids_sous_categorie_affectees = explode(',',$sous_categorie_affectee['id_foreign_sous_categorie']);
				foreach ($ids_sous_categorie_affectees as $key => $id_sous_categorie_affectees) {
					$sous_categorie = $this->Sous_categorie_model->get_sous_categorie_comptable($id_sous_categorie_affectees);
					if(!empty($sous_categorie)){
						$categorie_comptable =  $this->Categorie_plan_comptable_model->get_categorie_plan_comptable( $sous_categorie['id_foreign_categorie_plan_comptable']);
						if(!empty($categorie_comptable)){
							if((int) $categorie_comptable['id_foreign_type_categorie_plan_comptable'] == 2){
								$sous_categorie_affectee_result[ $sous_categorie['id_sous_categorie_comptable'] ] =$sous_categorie['code_comptable']." - ".$sous_categorie['designation_sous_categorie_plan_comptable'];
							}
						}
					}
				}
			}
		}
		return $sous_categorie_affectee_result;
	}
	
}
