<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Marchandise extends CI_Controller {

	public function index()
	{
		if(  $this->session->logged_in ){

			if(check_privilege('marchandise', $this->session->user['id_role'], 'voir')){

				$crud = new grocery_CRUD();
				$crud->set_table('marchandise');
				$crud->columns('nom_marchandise','prix');
				$crud->display_as('nom_marchandise','Nom de la marchandise');
				$crud->display_as('prix','Prix de la marchandise en $');
				$crud->set_subject('Une marchandise');

				$crud->callback_after_insert(array($this, '_onRowInserted'));
				$crud->callback_after_update(array($this, '_onRowUpdated'));
				$crud->callback_before_delete(array($this, '_onRowDeleted'));

				$crud->required_fields('nom_marchandise','prix');
				$crud->unset_clone();
				$this->stateDisplay($crud);

				if( ! check_privilege('marchandise', $this->session->user['id_role'], 'ajouter') ){
					$crud->unset_add();
				}

				if( ! check_privilege('marchandise', $this->session->user['id_role'], 'editer') ){
					$crud->unset_edit();
				}

				if( ! check_privilege('marchandise', $this->session->user['id_role'], 'voir') ){
					$crud->unset_read();
				}

				if( ! check_privilege('marchandise', $this->session->user['id_role'], 'supprimer') ){
					$crud->unset_delete();
				}

				$output = $crud->render();

				$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$sidebar = $this->load->view("layouts/sidebar", [], true);
				$navbar = $this->load->view("layouts/navbar", [], true);
				$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$this->load->view("marchandise/marchandise", ['header' => $header, 'navbar'=>$navbar, 'sidebar' => $sidebar, 'footer' => $footer,'output'=>$output->output]);

			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}
	
		}else {
			redirect("Starter/login");
		}
	
	}

	public function stateDisplay($crud){
		$state = $crud->getState();

		switch ($state) {
			case 'read':
				$crud->set_subject("Une marchandise ");
				break;
			case 'list':
				$crud->set_subject("Une marchandise ");
				break;
			case 'add':
				$crud->set_subject("D'une marchandise ");
				break;
			
			case 'edit':
				$crud->set_subject("D'une marchandise ");
				break;
			
			default:
				break;
		}

	}

	public function _showImage($value,$row)
	{
		return "<img src='".base_url('assets/uploads/files/'.$value)."' width='100px' height='100px' style='object-fit: content;'/>";
	}

	public function _onRowInserted($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'marchandise',
			"id_champ"=> $primary_key,
			"action" => "insertion", 
			"text_descriptif" => "ajout de la marchandise ".$post_array["nom_marchandise"],
			"date_heure" => date("Y-m-d H:m:i")
		];

		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowUpdated($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'marchandise',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "mise à jour de la marchandise ".$post_array["nom_marchandise"],
			"date_heure" => date("Y-m-d H:m:i")
		];

    
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowDeleted($primary_key)
	{
		$data = ['id_marchandise'=>$primary_key];
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'marchandise',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "suppression de la marchandise ".$this->ModelGetTableRow->getObjectFieldValue($data,'marchandise')->nom_marchandise,
			"date_heure" => date("Y-m-d H:m:i")		
		];
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	
}
