<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Sous_categorie_comptable_affecte extends CI_Controller {

	public function index()
	{
		if(  $this->session->logged_in ){
			if(check_privilege('sous_categorie_comptable', $this->session->user['id_role'], 'voir')){
				
				$crud = new grocery_CRUD();
				$settings_link_active	= 'link_menu_active';

				if( $_SESSION['user']['id_foreign_entreprise_salesienne'] <> 0){
					$crud->where(['id_foreign_entreprise_salesienne'=>$_SESSION['user']['id_foreign_entreprise_salesienne']]);
				}

				$crud->set_table('sous_categorie_comptable_affectee');
				$crud->columns('id_sous_categorie_comptable_affectee','id_foreign_sous_categorie','id_foreign_entreprise_salesienne');
				$crud->display_as('id_sous_categorie_comptable_affectee','#');
				$crud->display_as('id_foreign_sous_categorie','Sous Categorie Comptable');
				$crud->display_as('id_foreign_entreprise_salesienne','Oeuvre de Don Bosco');
				$crud->set_subject('Une Sous Categorie Comptable Affectée');
	
				$crud->callback_after_insert(array($this, '_onRowInserted'));
				$crud->callback_after_update(array($this, '_onRowUpdated'));
				$crud->callback_before_delete(array($this, '_onRowDeleted'));
	
				$sous_categorie_plan_comptables = $this->buildSousCategoriePlanComptableAffectee(); 
				$crud->field_type('id_foreign_sous_categorie','multiselect',$sous_categorie_plan_comptables);
				$crud->field_type('id_foreign_entreprise_salesienne','hidden', $_SESSION['user']['id_foreign_entreprise_salesienne'] );
				$crud->callback_column('id_foreign_entreprise_salesienne',array($this,'_callback_entreprise_salesienne'));
				$crud->unset_clone();
				$this->stateDisplay($crud);

				if( ! check_privilege('sous_categorie_comptable', $this->session->user['id_role'], 'ajouter') ){
					$crud->unset_add();
				}

				if( ! check_privilege('sous_categorie_comptable', $this->session->user['id_role'], 'editer') ){
					$crud->unset_edit();
				}

				if( ! check_privilege('sous_categorie_comptable', $this->session->user['id_role'], 'voir') ){
					$crud->unset_read();
				}

				if( ! check_privilege('sous_categorie_comptable', $this->session->user['id_role'], 'supprimer') ){
					$crud->unset_delete();
				}


				if( $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0 ){
					$crud->unset_add();
					$crud->unset_edit();
					$crud->unset_delete();
				}

				$crud->order_by('id_sous_categorie_comptable_affectee','desc');
	
				$output = $crud->render();
	
				$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$sidebar = $this->load->view("layouts/sidebar", [], true);
				$navbar = $this->load->view("layouts/menu_nav_bar", ['settings_link_active'=>$settings_link_active], true);
				$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$this->load->view("sous_categorie_comptable_affectee/sous_categorie_comptable_affectee", ['header' => $header, 'navbar'=>$navbar, 'sidebar' => $sidebar, 'footer' => $footer,'output'=>$output->output]);	

			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}	
		}else {
			redirect("Starter/login");
		}
	}

	public function stateDisplay($crud){
		$state = $crud->getState();

		switch ($state) {
			case 'read':
				$crud->set_subject("Une Sous Categorie Comptable Affectée ");
				break;
			case 'list':
				$crud->set_subject("Une Sous Categorie Comptable Affectée ");
				break;
			case 'add':
				$crud->set_subject("D'Une Sous Categorie Comptable Affectée ");
				break;
			
			case 'edit':
				$crud->set_subject("D'Une Sous Categorie Comptable Affectée ");
				break;
			
			default:
				break;
		}

	}

	public function _showImage($value,$row)
	{
		return "<img src='".base_url('assets/uploads/files/'.$value)."' width='100px' height='100px' style='object-fit: content;'/>";
	}

	public function _onRowInserted($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Sous Categorie Comptable Affectée ',
			"id_champ"=> $primary_key,
			"action" => "insertion", 
			"text_descriptif" => "ajout d'Une Sous Categorie Comptable Affectée ID : ".$primary_key,
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowUpdated($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Sous Categorie Comptable Affectée',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "mise à jourde de la Sous Categorie Comptable Affectée ID : ".$primary_key,
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

    
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowDeleted($primary_key)
	{
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Sous Categorie Comptable',
			"id_champ"=> $primary_key,
			"action" => "Suppression",
			"text_descriptif" => "suppression de la Sous Categorie Comptable Affectée ID : ".$primary_key,
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")		
		];
		$this->Action_utilisateur_model->add( $action );
		return true;
	}
	
	public function _callback_entreprise_salesienne($value, $row){
		$entreprise_salesienne = $this->Entreprise_salesienne_model->get_entreprise_salesienne($value);
		if(!empty($entreprise_salesienne)){
			return '<span> '.$entreprise_salesienne['nom_entreprise_salesienne']. ' <span>';
		}
	}


	public function buildSousCategoriePlanComptableAffectee(){
		$sous_categorie_plan_comptables 		= $this->Sous_categorie_model->get_all_sous_categorie_comptables();
		$sous_categorie_plan_comptables_final	= [];
		if(!empty($sous_categorie_plan_comptables)){
			foreach ($sous_categorie_plan_comptables as $key => $sous_categorie_plan_comptable) {
				$sous_categorie_plan_comptables_final[$sous_categorie_plan_comptable['id_sous_categorie_comptable']] = $sous_categorie_plan_comptable['code_comptable'].'-'.$sous_categorie_plan_comptable['designation_sous_categorie_plan_comptable'].'<br>';
			}
		}
		return $sous_categorie_plan_comptables_final;
	}

	public function InsertSousCategorieComptableAffecteeEntreprise()
	{
		$sous_categorie_plan_comptables = $this->Sous_categorie_model->get_sous_categorie_comptable_by_id_entreprise( $_SESSION['user']['id_foreign_entreprise_salesienne'] );
		$string_ids = '';
		if(!empty($sous_categorie_plan_comptables)){
			foreach ($sous_categorie_plan_comptables as $sous_categorie_plan_comptable) {
				$string_ids.= $sous_categorie_plan_comptable['id_sous_categorie_comptable'].',';
			}
		}
		$string_ids = substr($string_ids, 0,-1);

		

		$sous_categorie_plan_comptable_affectes = $this->Sous_categorie_affectee_model->get_sous_categorie_comptable_affectee_by_id_entreprise( $_SESSION['user']['id_foreign_entreprise_salesienne'] );
		$update_insert_sous_categorie_plan_comptable_affecte = [
			'id_foreign_sous_categorie'=>$string_ids,
			'id_foreign_entreprise_salesienne'=> $_SESSION['user']['id_foreign_entreprise_salesienne']
		];

		if( !empty( $sous_categorie_plan_comptable_affectes )){
			$sous_categorie_plan_comptable_affecte  = $sous_categorie_plan_comptable_affectes[0];
			$this->Sous_categorie_affectee_model->update($sous_categorie_plan_comptable_affecte['id_sous_categorie_comptable_affectee'],$update_insert_sous_categorie_plan_comptable_affecte);
			$action = [
				"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
				"nom_table"=> 'Sous Categorie Comptable Affectée',
				"id_champ"=> $sous_categorie_plan_comptable_affecte['id_sous_categorie_comptable_affectee'],
				"action" => "mise à jour",
				"text_descriptif" => "mise à jourde de la Sous Categorie Comptable Affectée ID : ".$sous_categorie_plan_comptable_affecte['id_sous_categorie_comptable_affectee'],
				'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
				"date_heure" => date("Y-m-d H:m:i")
			];
			$this->Action_utilisateur_model->add( $action );
		}else{

			$id_sous_categorie_plan_comptable_affecte = $this->Sous_categorie_affectee_model->add($update_insert_sous_categorie_plan_comptable_affecte);
			$action = [
				"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
				"nom_table"=> 'Sous Categorie Comptable Affectée ',
				"id_champ"=> $id_sous_categorie_plan_comptable_affecte,
				"action" => "insertion", 
				"text_descriptif" => "ajout d'Une Sous Categorie Comptable Affectée ID : ".$id_sous_categorie_plan_comptable_affecte,
				'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
				"date_heure" => date("Y-m-d H:m:i")
			];
	
			$this->Action_utilisateur_model->add( $action );
		}
		redirect('Sous_categorie_comptable_affecte/index/');
	}



	public function InsertSousCategorieComptableAffecteeProvincialat()
	{

		$sous_categorie_plan_comptables = $this->Sous_categorie_model->get_all_sous_categorie_comptables(  );
		$string_ids = '';
		if(!empty($sous_categorie_plan_comptables)){
			foreach ($sous_categorie_plan_comptables as $sous_categorie_plan_comptable) {
				$string_ids.= $sous_categorie_plan_comptable['id_sous_categorie_comptable'].',';
			}
		}
		$string_ids = substr($string_ids, 0,-1);

		
		$sous_categorie_plan_comptable_affectes = $this->Sous_categorie_affectee_model->get_sous_categorie_comptable_affectee_by_id_entreprise( $_SESSION['user']['id_foreign_entreprise_salesienne'] );
		$update_insert_sous_categorie_plan_comptable_affecte = [
			'id_foreign_sous_categorie'=>$string_ids,
			'id_foreign_entreprise_salesienne'=> $_SESSION['user']['id_foreign_entreprise_salesienne']
		];

		if( !empty( $sous_categorie_plan_comptable_affectes )){
			$sous_categorie_plan_comptable_affecte  = $sous_categorie_plan_comptable_affectes[0];
			$this->Sous_categorie_affectee_model->update($sous_categorie_plan_comptable_affecte['id_sous_categorie_comptable_affectee'],$update_insert_sous_categorie_plan_comptable_affecte);
			$action = [
				"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
				"nom_table"=> 'Sous Categorie Comptable Affectée',
				"id_champ"=> $sous_categorie_plan_comptable_affecte['id_sous_categorie_comptable_affectee'],
				"action" => "mise à jour",
				"text_descriptif" => "mise à jourde de la Sous Categorie Comptable Affectée ID : ".$sous_categorie_plan_comptable_affecte['id_sous_categorie_comptable_affectee'],
				'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
				"date_heure" => date("Y-m-d H:m:i")
			];
			$this->Action_utilisateur_model->add( $action );
		}else{

			$id_sous_categorie_plan_comptable_affecte = $this->Sous_categorie_affectee_model->add($update_insert_sous_categorie_plan_comptable_affecte);
			$action = [
				"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
				"nom_table"=> 'Sous Categorie Comptable Affectée ',
				"id_champ"=> $id_sous_categorie_plan_comptable_affecte,
				"action" => "insertion", 
				"text_descriptif" => "ajout d'Une Sous Categorie Comptable Affectée ID : ".$id_sous_categorie_plan_comptable_affecte,
				'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
				"date_heure" => date("Y-m-d H:m:i")
			];
	
			$this->Action_utilisateur_model->add( $action );
		}
		redirect('Sous_categorie_comptable_affecte/index/');
	}

}
