<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Type_unite_one extends CI_Controller {

	public function index()
	{
		if(  $this->session->logged_in ){
			if(check_privilege('type_unite', $this->session->user['id_role'], 'voir')){
				
				$crud = new grocery_CRUD();
				$settings_link_active = 'link_menu_active';
				
				if( $_SESSION['user']['id_foreign_entreprise_salesienne'] <> 0){
					$crud->where(['id_foreign_entreprise_salesienne'=>$_SESSION['user']['id_foreign_entreprise_salesienne']]);
				}

				$crud->set_table('type_unite_one');
				$crud->columns('id_type_unite_one','designation_type_unite_one','id_foreign_entreprise_salesienne');
				$crud->display_as('id_type_unite_one','#');
				$crud->display_as('designation_type_unite_one','Designation');
				$crud->display_as('id_foreign_entreprise_salesienne','Entreprise');
				$crud->set_subject("Un Type d'unité de mesure ");
	
				$crud->callback_after_insert(array($this, '_onRowInserted'));
				$crud->callback_after_update(array($this, '_onRowUpdated'));
				$crud->callback_before_delete(array($this, '_onRowDeleted'));
	

				$crud->required_fields('designation_type_unite_one');
				$crud->field_type('id_foreign_entreprise_salesienne','hidden', $_SESSION['user']['id_foreign_entreprise_salesienne'] );
				$crud->callback_column('id_foreign_entreprise_salesienne',array($this,'_callback_entreprise_salesienne'));
				$crud->unset_clone();
				$this->stateDisplay($crud);

				if( ! check_privilege('type_unite', $this->session->user['id_role'], 'ajouter') ){
					$crud->unset_add();
				}

				if( ! check_privilege('type_unite', $this->session->user['id_role'], 'editer') ){
					$crud->unset_edit();
				}

				if( ! check_privilege('type_unite', $this->session->user['id_role'], 'voir') ){
					$crud->unset_read();
				}

				if( ! check_privilege('type_unite', $this->session->user['id_role'], 'supprimer') ){
					$crud->unset_delete();
				}


				if( $_SESSION['user']['id_foreign_entreprise_salesienne'] == 0){
					$crud->unset_add();
					$crud->unset_edit();
					$crud->unset_delete();				
				}

				$crud->order_by('id_type_unite_one','desc');
	
				$output = $crud->render();
	
				$header = $this->load->view("layouts/header", ["css_files"=>$output->css_files], true);
				$sidebar = $this->load->view("layouts/sidebar", [], true);
				$navbar = $this->load->view("layouts/menu_nav_bar", ['settings_link_active'=>$settings_link_active], true);				$footer = $this->load->view("layouts/footer", ["js_files"=>$output->js_files], true);
				$this->load->view("type_unite_one/type_unite_one", ['header' => $header, 'navbar'=>$navbar, 'sidebar' => $sidebar, 'footer' => $footer,'output'=>$output->output]);	

			}else{
				redirect($_SERVER['HTTP_REFERER']);
			}	
		}else {
			redirect("Starter/login");
		}
	}

	public function stateDisplay($crud){
		$state = $crud->getState();

		switch ($state) {
			case 'read':
				$crud->set_subject("Un Type d'unité de mesure ");
				break;
			case 'list':
				$crud->set_subject("Un Type d'unité de mesure ");
				break;
			case 'add':
				$crud->set_subject("D'Un Type d'unité de mesure ");
				break;
			
			case 'edit':
				$crud->set_subject("D'Un Type d'unité de mesure ");
				break;
			
			default:
				break;
		}

	}

	public function _showImage($value,$row)
	{
		return "<img src='".base_url('assets/uploads/files/'.$value)."' width='100px' height='100px' style='object-fit: content;'/>";
	}

	public function _onRowInserted($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Type unité one ',
			"id_champ"=> $primary_key,
			"action" => "insertion", 
			"text_descriptif" => "ajout d'Un Type d\'unité mesure ".$post_array["designation_type_unite_one"],
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowUpdated($post_array, $primary_key)
	{
		
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Type unité one ',
			"id_champ"=> $primary_key,
			"action" => "mise à jour",
			"text_descriptif" => "mise à jourde du Type unité one  ".$post_array["designation_type_unite_one"],
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")
		];

    
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _onRowDeleted($primary_key)
	{
		$data = ['id_type_unite_one'=>$primary_key];
		$action = [
			"id_utilisateur"=> $_SESSION['user']['id_utilisateur'],
			"nom_table"=> 'Type unité one ',
			"id_champ"=> $primary_key,
			"action" => "Suppression",
			"text_descriptif" => "suppression du Type unité one  ".$this->ModelGetTableRow->getObjectFieldValue($data,'type_unite_one')->designation_type_unite_one,
			'id_foreign_entreprise_salesienne_action_utilisateur'=> $_SESSION['user']['id_foreign_entreprise_salesienne'],
			"date_heure" => date("Y-m-d H:m:i")		
		];
		$this->Action_utilisateur_model->add( $action );
		return true;
	}

	public function _callback_entreprise_salesienne($value, $row){
		$entreprise_salesienne = $this->Entreprise_salesienne_model->get_entreprise_salesienne($value);
		if(!empty($entreprise_salesienne)){
			return '<span> '.$entreprise_salesienne['nom_entreprise_salesienne']. ' <span>';
		}
	}
	
}
