<?php

    function action_utilisateur($data, $model){
        $model->add($data);
    }

    function generate_token(){
        $string = date("Y-m-d H:i:s") .''. $_SESSION['user']['id_utilisateur'];
        return sha1($string);
    }

    function generate_token1($id){
        $string = date("Y-m-d H:i:s") .''. $id;
        return sha1($string);
    }

    function check_privilege($fonctionnalite, $idrole, $operation){
        $CI = &get_instance();
        $fonct = $CI->db->get_where("fonctionnalite", array("short_code" => $fonctionnalite))->row_array();
        if(!empty($fonct)){
            $permission = $CI->db->get_where("role_permission", array("id_role" => $idrole, "id_fonctionnalite" => $fonct['id_fonctionnalite']))->row_array();
            if(!empty($permission)){
                switch($operation){
                    case "voir" :
                        if($permission['peux_voir'] == 1){
                            return true;
                        } else {
                            return false;
                        }
                    break;
                    case "ajouter" :
                        if($permission['peux_ajouter'] == 1){
                            return true;
                        } else {
                            return false;
                        }
                    break;
                    case "editer" :
                        if($permission['peux_editer'] == 1){
                            return true;
                        } else {
                            return false;
                        }
                    break;
                    case "supprimer" :
                        if($permission['peux_supprimer'] == 1){
                            return true;
                        } else {
                            return false;
                        }
                    break;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }


    function ellipsis($string, $max_length) {
	    return (strlen($string) > $max_length) ? substr($string,0,strrpos(substr($string, 0, $max_length), ' '))."..." : $string;
	}

    function echoTab ($data){
        echo "<pre>";
        print_r($data);
        echo "</pre>";
    }

    
    function echoDie ($data){
        echo "<pre>";
        print_r($data);
        echo "</pre>";
        die;
    }

    function in_multiarray($elem, $array,$field)
    {
        $top = sizeof($array) - 1;
        $bottom = 0;
        while($bottom <= $top)
        {
            if($array[$bottom][$field] == $elem)
                return true;
            else 
                if(is_array($array[$bottom][$field]))
                    if(in_multiarray( $elem, ( $array[$bottom][$field] ),$field ) )
                        return true;

            $bottom++;
        }        
        return false;
    }

    function isMobile() {
        return preg_match("/(android|avantgo|blackberry|bolt|boost|cricket|docomo|fone|hiptop|mini|mobi|palm|phone|pie|tablet|up\.browser|up\.link|webos|wos)/i", $_SERVER["HTTP_USER_AGENT"]);
    }

    function get_month_array()
    {
        return ['01' => 'JANVIER', '02' => 'FEVRIER', '03' => 'MARS', '04' => 'AVRIL', '05' => 'MAI', '06' => 'JUIN', '07' => 'JUILLET', '08' => 'AOUT', '09' => 'SEPTEMBRE', '10' => 'OCTOBRE', '11' => 'NOVEMBRE', '12' => 'DECEMBRE'];

    }
?>