<?php

    class Livre_caisse_banque_model extends CI_Model{

        function add($params){
            $this->db->insert("livre_caisse_banque", $params);
            return $this->db->insert_id();
        }

        function update($id, $params){
            $this->db->where("id_livre_caisse_banque", $id);
            return $this->db->update("livre_caisse_banque", $params);
        }

        function get_all_livre_caisse_banques(){
            $this->db->order_by('id_livre_caisse_banque', 'desc');
            return $this->db->get('livre_caisse_banque')->result_array();
        }

        function get_livre_caisse_banque_by_id_entreprise($token){
            return $this->db->get_where('livre_caisse_banque',array('id_foreign_entreprise_salesienne_livre_caisse_banque'=>$token))->result_array();
        }

        function get_livre_caisse_banque($id){
            return $this->db->get_where('livre_caisse_banque',array('id_livre_caisse_banque'=>$id))->row_array();
        }

        function get_livre_caisse_banques_by_query($sql_query){
            $query = $this->db->query($sql_query)->result_array();
            return $query;
        }


        public function get_last_livre_caisse_banque_table_row()
        {
            $this->db->select("*");
            $this->db->from("livre_caisse_banque");
            $this->db->limit(1);
            $this->db->order_by('id_livre_caisse_banque',"DESC");
            $query  = $this->db->get();
            $result = $query->row_array();
            return $result;
        }


        public function get_last_livre_caisse_banque_table_row_by_id_device_type_livre($id_devise, $id_type_compte,$sql)
        {
            $query = $this->db->query("SELECT * FROM livre_caisse_banque WHERE id_foreign_devise = $id_devise AND id_foreign_type_compte_livre_caisse = $id_type_compte AND $sql ORDER BY id_livre_caisse_banque DESC LIMIT 1")->row_array();
            return $query;
        }

        function delete_livre_caisse_banque($token){
            $this->db->where("id_livre_caisse_banque", $token);
            return $this->db->delete("livre_caisse_banque");
        }

        public function get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_annee_exrcice($id_entreprise,$id_sous_cat_compt,$annee_exrcice)
        {
            $start_date =  $annee_exrcice.'/09/01';
            $end_date   = ((int)$annee_exrcice+1).'/08/31';
            $query = $this->db->query("SELECT  SUM(montant_livre_caisse_banque_converti) AS montant_realiser  FROM livre_caisse_banque WHERE id_foreign_entreprise_salesienne_livre_caisse_banque =$id_entreprise AND id_foreign_categorie_comptable =$id_sous_cat_compt AND date_enregistrement_livre_caisse_banque BETWEEN '$start_date' AND '$end_date'")->row_array();
            return $query['montant_realiser'];
        }

        public function get_sum_colonne_by_id_entreprise_id_sous_categorie_comptable_type_transation($id_sous_cat_compt,$id_type_trx,$sql)
        {
            $query = $this->db->query("SELECT  SUM(montant_livre_caisse_banque_converti) AS montant_realiser  FROM livre_caisse_banque WHERE id_foreign_categorie_comptable =$id_sous_cat_compt AND id_foreign_type_trx =$id_type_trx AND $sql ")->row_array();
            return $query['montant_realiser'];
        }


        public function get_sum_colonne_by_id_sous_categorie_comptable_sql($id_sous_cat_compt,$sql)
        {
            $query = $this->db->query("SELECT  SUM(montant_livre_caisse_banque_converti) AS montant_realiser  FROM livre_caisse_banque WHERE id_foreign_categorie_comptable =$id_sous_cat_compt AND $sql ")->row_array();
            return $query['montant_realiser'];
        }

    }

?>