<?php

    class Province_model extends CI_Model{

        function add($params){
            $this->db->insert("province", $params);
            return $this->db->insert_id();
        }

        function update($id, $params){
            $this->db->where("id_province", $id);
            return $this->db->update("province", $params);
        }

        function get_all_provinces(){
            $this->db->where('is_deleted', 0);
            $this->db->order_by('id_province', 'desc');
            return $this->db->get('province')->result_array();
        }

        function get_province_by_token($token){
            return $this->db->get_where('province',array('token_province'=>$token, 'is_deleted' => 0))->row_array();
        }

        function get_province($id){
            return $this->db->get_where('province',array('id_province'=>$id, 'is_deleted' => 0))->row_array();
        }

        function delete_province($token){
            $this->db->where("token_province", $token);
            $this->db->set('is_deleted', 1);
            return $this->db->update("province");
        }

    }

?>